# Software for the Autonomous Robotic Observation and Behavioral Analysis system
#
# Power management
#
# Copyright 2025 Jiri Ulrich 
#
# Commercial use of the software requires written consent of the copyright holders. 
#
# For Open Research and Educational use, the following applies:
#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at

#   http://www.apache.org/licenses/LICENSE-2.0

# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
#!/usr/bin/env python3

import time
import rospy
from std_srvs.srv import SetBool, SetBoolRequest, SetBoolResponse

from PyP100 import PyP100


class PowerPlug():

    USERNAME = 'roboroyalehivepowercontrol@gmail.com'
    PASSWORD = 'R0b0H1v3!'

    TURN_ON = True
    TURN_OFF = False

    def __init__(self):
        rospy.init_node('power_plug')

        if rospy.has_param('~ip_address'):
            self.ip_address = rospy.get_param('~ip_address')
        else:
            rospy.logerr('PowerPlug IP is not set')
            exit(1)

        self.plug_name = rospy.get_namespace()
        self.plug_srv = rospy.Service('~set_state', SetBool, self.state_cb)

        rospy.loginfo(f'PowerPlug {self.plug_name} {self.ip_address} initialized')

    def state_cb(self, request):
        rospy.loginfo(f'PowerPlug {self.plug_name} received request: {str(request.data)}')

        response = SetBoolResponse()

        try:
            self.plug = PyP100.P100(self.ip_address, PowerPlug.USERNAME, PowerPlug.PASSWORD)
            
            if request.data == PowerPlug.TURN_ON:
                self.plug.turnOn()
                response.message = 'Turned on'
            else:  # PowerPlug.TURN_OFF
                self.plug.turnOff()
                response.message = 'Turned off'

            response.success = True

        except Exception as ex:
            response.success = False
            response.message = 'Err: ' + str(ex)

        # time.sleep(5)  # slow down to avoid overwhelming the plug

        rospy.loginfo(f'PowerPlug {self.plug_name} success: {str(response.success)} msg: {response.message}')

        return response


if __name__ == '__main__':
    pp = PowerPlug()
    rospy.spin()

