# rr_power_plug

Simple ROS interface for TP-Link Tapo P100 power plug to turn on/off.

**DO NOT ENABLE TWO-FACTOR AUTHENTICATION**

## Set up

0. Install the dependencies below
0. Download the `TP-link Tapo` app to your phone
0. Log in to the Tapo account
0. Connect the plug to your account and to the local wifi
0. The app will ask for checking firmware updates. Do it carefully. Update the plug firmware to hopefully match the tested version below as it should support to set a default state when plugged in. If the version is not avaiable, do not update it. Rather notify others to run tests whether the API changed.
   - Tested with HW version `1.20.0` and FW version `1.5.5 Build 20230927 Rel. 40646`
0. In the app, set the default state to `On` in the device settings
0. Assign static IP to each plug in the wifi router
0. Put the plug's ip address into the launch file.
0. Also adjust the namespace and node name as necessary.

## Dependencies

- PyP100 library

  `pip install git+https://github.com/almottier/TapoP100.git@04c452fd8af9d8505e4177ba3df157372ce3ee0c`

## ROS interface description

### Name

- set node namespace to distinguish individual nodes and plugs

### Parameters

- `~ip_address` - local IP address


### Services

- `~set_state` to turn on and off the plug.
  - type: `std_srvs/SetBool`

Service data structure

```
bool data       # True - turn on, False - turn off
---
bool success    # return state of the request
string message  # status message including errors with codes
```


# LICENCE Information:

The use of this software requires written consent by the first maintaner of the roborolaye repository it originated from.
