/*
Software for the Autonomous Robotic Observation and Behavioral Analysis system. 

Diagnostics and state aggregation

Copyright 2025 Tomas Krajnik 

Commercial use of the software requires written consent of the copyright holders. 
For Open Research and Educational use, the following applies:

Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements.  See the NOTICE file
distributed with this work for additional information
regarding copyright ownership.  The ASF licenses this file
to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.



*/




#include <ros/ros.h>
#include <stdio.h>
#include <image_transport/image_transport.h>
#include <string>
#include <std_msgs/String.h>
#include <std_msgs/Int32MultiArray.h>
#include <time.h>
#include <cv_bridge/cv_bridge.h>
#include <sensor_msgs/image_encodings.h>
#include <opencv2/opencv.hpp>


#define SIDE_NUMBER 2
#define HIVE_NUMBER 4

/*used to switch between combs*/
image_transport::Subscriber mainImageSub[HIVE_NUMBER][SIDE_NUMBER];
ros::Subscriber numSummarySub[HIVE_NUMBER];

char discord[11000]; 
int images = 0;
int ratios[HIVE_NUMBER];
int trackLength[HIVE_NUMBER];
int sideSwaps[HIVE_NUMBER];
int lastSeen[HIVE_NUMBER];

/*ros and image transport handles*/
image_transport::ImageTransport *it;
ros::NodeHandle *nh;
cv::Mat image[HIVE_NUMBER][SIDE_NUMBER];
cv::Mat completeImage(1080/2+10+100,1920+30,CV_8UC1);
ros::Timer timer; 

const char keys[] = {"DISCORD KEYS GO HERE"};

void sendImage() 
{
    sprintf(discord,"curl -v -H \"Authorization: Bot TOKEN\" -H \"User-Agent: GrazMasterPCBot http://roboroyale.eu, v0.1\" -H \"Content-Type: multipart/form-data\" -X POST -F \'payload_json=\{\"username\": \"Aggregator\", \"content\": \"Composed hive image\"}\' -F \"file1=@/home/master/all.jpg\" https://discord.com/api/webhooks/%s ",keys);
    system(discord);
}

void describe()
{
for (int i = 0;i<4;i++)
	{
		char text[1000];
		if (trackLength[i] > 0)	sprintf(text,"Tracked for %02i:%02i:%02i-%.1f%%.",trackLength[i]/3600,trackLength[i]%3600/60,trackLength[i]%60,ratios[i]/10.0);
		if (trackLength[i] <= 0)sprintf(text,"Lost for %02i:%02i:%02is-%.1f%%.",lastSeen[i]/3600,lastSeen[i]%3600/60,lastSeen[i]%60,ratios[i]/10.0);
		putText(completeImage,text, cv::Point(i*(1920/4+10),30), cv::FONT_HERSHEY_DUPLEX, 0.95, cv::Scalar(255), 1.0);
		sprintf(text,"Queen swapped side %i times.",sideSwaps[i]);
		putText(completeImage,text, cv::Point(i*(1920/4+10),70), cv::FONT_HERSHEY_DUPLEX, 0.95, cv::Scalar(255), 1.0);
	}
}

void timerCallback(const ros::TimerEvent&)
{
    describe();	
	cv::imwrite("/home/master/all.jpg",completeImage);
	sendImage();
    ROS_INFO("Reporting image");
	completeImage.setTo(0);
}

/*used to get pictures of comb with the honeybee queen*/
void summaryCallback(const std_msgs::Int32MultiArrayConstPtr& msg)
{
	int hive = msg->data[0];
	if (hive >= 0 && hive < HIVE_NUMBER){
		ratios[hive] = msg->data[1];	
		trackLength[hive] = msg->data[2];
		sideSwaps[hive] = msg->data[3];
		lastSeen[hive] = msg->data[4];


	}else{
		ROS_WARN("Reported hive number is out of range");
	}
}

/*used to get pictures of comb with the honeybee queen*/
void mainImageCallback(const sensor_msgs::ImageConstPtr& msg)
{
    cv_bridge::CvImagePtr cv_ptr;
    int h = msg->header.frame_id.c_str()[6]-'0';
    int s = msg->header.frame_id.c_str()[11]-'0';
    ROS_INFO("Image %s - %i %i",msg->header.frame_id.c_str(),h,s);
    cv::Rect roi(3*1920/8,3*1080/8,1920/4,1080/4);
    image[h][s] = cv::Mat(1080, 1920,CV_8UC1, (void*)msg->data.data());
    image[h][s](roi).copyTo(completeImage(cv::Rect(h*(1920/4+10),s*(1080/4+10)+100,1920/4,1080/4)));
    images++;
}

int main(int argc, char **argv)
{
    ros::init(argc, argv, "xy_aggregator");
    nh = new ros::NodeHandle();
    it = new image_transport::ImageTransport(*nh);
    char topicName[1000];
    for (int h = 0;h<HIVE_NUMBER;h++){
        for (int s = 0;s<SIDE_NUMBER;s++)
        {
            image[h][s] = cv::Mat(1920,1080,CV_8UC1); 
            sprintf(topicName,"/hive_%i/xy_%i/report_image",h,s);
            ROS_INFO("Subscribing to %s",topicName);
            mainImageSub[h][s] = it->subscribe(topicName, 1,mainImageCallback);
        }
        sprintf(topicName,"/hive_%i/numerical_summary",h);
        numSummarySub[h] = nh->subscribe(topicName, 1,summaryCallback); 
    }
    ROS_INFO("WAIT");

    while (images < 8){ros::spinOnce();sleep(1);}
    describe();    
    cv::imwrite("/home/master/all.jpg",completeImage);
    sendImage();
	completeImage.setTo(0);
    timer = nh->createTimer(ros::Duration(600), timerCallback);
    
    ros::spin();
    return 0;
}


