#!/bin/bash

##########
# PROVIDE FULL PATH TO THE WORKSPACE SRC FOLDER
#
# FULL PATHS TO ADDITIONAL REPOSITORIES CAN BE ADDED TO THE "ADDITIONAL_REPOS" ARRAY SEPARATED BY SPACE
##########

WORKSPACE_SRC="${HOME}/workspace/src"
declare -a ADDITIONAL_REPOS=("${HOME}/rr_os_setup")



function report
{
curl -v \
-H "Authorization: Bot TOKEN" \
-H "User-Agent: GrazMasterPCBot (http://roboroyale.eu, v0.1)" \
-H "Content-Type: application/json" \
-X POST \
-d '{"content":"'"$1"'"}' \
https://discord.com/api/webhooks/1243472172526338068/bvomPhDJrQ3CBVejTlxRkrAPbxjMVZSgzNjOsunR93QzLcnQYAkQibN3FGagKPCc0A1d
}

function check_git
{
git fetch
N=$(git status --porcelain=v1 2>/dev/null | wc -l)
if [ "$N" -ne 0 ]; then
    report "[WARNING] ${HOSTNAME} ${EXPERIMENT}: There are uncommited local changes in $1 !!!"
fi
BEHIND=$(git rev-list --count HEAD..@{u})
AHEAD=$(git rev-list --count @{u}..HEAD)
if [ "$BEHIND" -ne 0 ] || [ "$AHEAD" -ne 0 ]; then
    report "[WARNING] ${HOSTNAME} ${EXPERIMENT}: $1 is not up to date !!!"
fi
}



cd ${WORKSPACE_SRC}
for D in `ls`; do
    cd ${D}
    check_git ${D}
    cd ../
done

for D in "${ADDITIONAL_REPOS[@]}"; do
    cd ${D}
    check_git ${D}
done

~/rr_os_setup/scripts/report-crontab.sh
