#!/bin/bash

##########
# PROVIDE FULL PATH TO THE WORKSPACE SRC FOLDER
#
# FULL PATHS TO ADDITIONAL REPOSITORIES CAN BE ADDED TO THE "ADDITIONAL_REPOS" ARRAY SEPARATED BY SPACE
##########

TOPIC="/master/current_repos"
WORKSPACE_SRC="${HOME}/workspace/src"
declare -a ADDITIONAL_REPOS=("${HOME}/rr_os_setup")



HASHES=""

cd ${WORKSPACE_SRC}
for D in `ls`; do
    cd ${D}
    H=`git log --pretty=format:'%H' -n 1`
    HASHES="${HASHES}#${D}=${H}"
    cd ../
done

for D in "${ADDITIONAL_REPOS[@]}"; do
    cd ${D}
    H=`git log --pretty=format:'%H' -n 1`
    HASHES="${HASHES}#${D}=${H}"
done

rostopic pub ${TOPIC} std_msgs/String "data: '${HASHES}'" --once


