#!/usr/bin/bash

NAS_IP="INSERT IP HERE"
NAS_VOLUME="Internal NAS VOLUME"

x=$(pwd)
cd /data/hdd
n=$(ls *.bag|head -n 1|sed s/.bag$//)

function report
{
curl -v \
-H "Authorization: Bot TOKEN" \
-H "User-Agent: GrazMasterPCBot (http://roboroyale.eu, v0.1)" \
-H "Content-Type: application/json" \
-X POST \
-d '{"content":"'"$1"'"}' \
https://discord.com/api/webhooks/WEBHOOK_CODE_GOES_HERE
}

if [ -e $n.bag ];
then
    if [ $(lsof -t $n.bag 2>/dev/null|wc -l) == 0 ];
    then

        source ~/workspace/devel/setup.bash
        start=$(date +%s)

        if [ -e $n.hdd.md5 ];
            then
                a=$(cat $n.hdd.md5)
                echo Local MD5 of $n exists, using it 
            else
                a=$(md5sum $n.bag|cut -f 1 -d ' ')
                echo $a >$n.hdd.md5
        fi
        end=$(date +%s)
        echo Local MD5 of $s calculated in $(($end-$start))s
 
        d=$(echo $HOSTNAME|grep -o [0-3])

        sh=$(ls -l $n.bag|awk '{print $5}')
        sn=$(ssh user@$NAS_IP -p PORT "ls -l $NAS_VOLUME/$n.bag"|awk '{print $5}')
        if [ $sh == $sn ];
        then 
            echo Filesizes match $sh $sn
            s=$(ls -sh $n.bag)

            start=$(date +%s)
            b=$(ssh user@$NAS_IP -p PORT "md5sum $NAS_VOLUME/$n.bag|cut -f 1 -d ' '") # update this folder on NAS vokume change
            echo $b >$n.nas.md5
            end=$(date +%s)
            echo Remote MD5 of $s calculated in $(($end-$start))s

            cp $n.info.txt /data/nas/
            mv $n.nas.md5 /data/nas/
            echo $a $b
            if [ $a == $b ]; then
                mv $n.bag /data/hdd/backup
                mv $n.info.txt /data/hdd/backup
                mv $n.hdd.md5 /data/hdd/backup
                touch /data/hdd/backup/$n.uploaded
                echo $n.bag verified and deleted
            else
                report "WARNING: HDD rosbag verification failed on hive $d due to different MD5"
                rm $n.hdd.md5
            fi
          else
            report "WARNING: HDD rosbag verification failed on hive $d due to different size"
            rm $n.hdd.md5
        fi
        echo ------------------------------------ 
    fi
else
    echo There are no files to be verified 
fi
report "FATAL: This is obsolate and should never be called"
cd $x
