#!/usr/bin/bash
x=$(pwd)
cd /data/hdd
n=$(ls *.bag|head -n 1|sed s/.bag$//)

NAS_IP="$1"
NAS_VOLUME="$2"
echo "HDD upload to " $NAS_IP " and " $NAS_VOLUME
function report
{
curl -v \
-H "Authorization: Bot TOKEN" -H "User-Agent: GrazMasterPCBot (http://roboroyale.eu, v0.1)" -H "Content-Type: application/json" -X POST -d '{"content":"'"$1"'"}' https://discord.com/api/webhooks/WEBHOOK_CODE_GOES_HERE >/dev/null 2>&1
}
echo $n

if [ -e $n.bag ];
then
    if [ $(lsof -t $n.bag 2>/dev/null|wc -l) == 0 ];
    then

        source ~/workspace/devel/setup.bash
        start=$(date +%s)

        if [ -e $n.hdd.md5 ];
            then
                a=$(cat $n.hdd.md5)
                echo Local MD5 of $n exists, using it 
            else
                a=$(md5sum $n.bag|cut -f 1 -d ' ')
                echo $a >$n.hdd.md5
        fi
        end=$(date +%s)
        echo Local MD5 of $s calculated in $(($end-$start))s
       
        d=$(echo $HOSTNAME|grep -o [0-3])
        re='^[0-9]+$'
        if ! [[ $d =~ $re ]] ; then
            d=$(shuf -i 0-3 -n 1)
        fi
    
        s=$(ls -sh $n.bag)
        start=$(date +%s)
        rsync --progress $n.bag /data/nas/
        end=$(date +%s)
        echo $s uploaded in $(($end-$start))s

        sh=$(ls -l $n.bag|awk '{print $5}')
        sn=0
        t=0
        while [ $sh != $sn ];
        do
            sn=$(ssh user@$NAS_IP -p PORT "ls -l $NAS_VOLUME/$n.bag"|awk '{print $5}')
            sleep 10
            t=$(($t+1))
            echo Upload status local: $sh nas: $sn
            if [ $t -gt 30 ];
            then
                sh=0
                sn=0
            fi
        done
        echo Upload completed

        start=$(date +%s)
        b=$(ssh user@$NAS_IP -p PORT "md5sum $NAS_VOLUME/$n.bag|cut -f 1 -d ' '") # update this folder on NAS volume change
        echo $b >$n.nas.md5
        end=$(date +%s)
        echo Remote MD5 of $s calculated in $(($end-$start))s
        cp $n.info.txt /data/nas/
        mv $n.nas.md5 /data/nas/

        if [ $a != $b ]; then
            echo MD5 mismatch - retrying
            start=$(date +%s)
            b=$(ssh user@$NAS_IP -p PORT "md5sum $NAS_VOLUME/$n.bag|cut -f 1 -d ' '") # update this folder on NAS volume change
            echo $b >$n.nas.md5
            end=$(date +%s)
            echo Remote MD5 of $s calculated in $(($end-$start))s
            cp $n.info.txt /data/nas/
            mv $n.nas.md5 /data/nas/
        fi

        echo $a $b
        if [ $a == $b ]; then
            mv $n.bag /data/hdd/backup
            mv $n.info.txt /data/hdd/backup
            mv $n.hdd.md5 /data/hdd/backup
            touch /data/hdd/backup/$n.uploaded
            echo $n.bag uploaded, verified and deleted
        else
            rm $n.hdd.md5
            report "WARNING: 1 HDD rosbag $n upload failed on hive $d"
        fi
    fi
    echo ------------------------------------ 
else
    echo There are no old files to be moved
fi

cd $x
