#!/usr/bin/bash
x=$(pwd)
cd ~/rosbags
n=$(ls *.bag|head -n 1|sed s/.bag$//)

NAS_IP="$1"
NAS_VOLUME="$2"
echo "stadart upload to " $NAS_IP " and " $NAS_VOLUME
function report
{
curl -v \
-H "Authorization: Bot TOKEN" \
-H "User-Agent: GrazMasterPCBot (http://roboroyale.eu, v0.1)" \
-H "Content-Type: application/json" \
-X POST \
-d '{"content":"'"$1"'"}' \
https://discord.com/api/webhooks/WEBHOOK_CODE_GOES_HERE >/dev/null 2>&1
}

echo $n
if [ -e $n.bag ];
then
    source ~/workspace/devel/setup.bash
   
    rosbag info $n.bag >$n.info.txt
    a=$(md5sum $n.bag|cut -f 1 -d ' ')
    echo $a >$n.hdd.md5

    mv $n.bag /data/hdd
    mv $n.info.txt /data/hdd
    mv $n.hdd.md5 /data/hdd
    cd /data/hdd
    d=$(echo $HOSTNAME|grep -o [0-3])
    re='^[0-9]+$'
    if ! [[ $d =~ $re ]] ; then
       d=0 #$(shuf -i 0-3 -n 1)
    fi
    
    sleep $(($d*360+1))
    rsync --progress $n.bag /data/nas/

    sh=$(ls -l $n.bag|awk '{print $5}')
    sn=0
    t=0
    while [ $sh != $sn ];
    do
        sn=$(ssh user@$NAS_IP -p PORT "ls -l $NAS_VOLUME/$n.bag"|awk '{print $5}')
        sleep 10
        t=$(($t+1))
        echo Waiting for complete upload: $sh vs $sn
        if [ $t -gt 30 ];
        then
            sh=0
            sn=0
        fi
    done

    b=$(ssh user@$NAS_IP -p PORT "md5sum $NAS_VOLUME/$n.bag|cut -f 1 -d ' '") # update this folder on NAS vokume change
    echo $b >$n.nas.md5
    cp $n.info.txt /data/nas/
    mv $n.nas.md5 /data/nas/

    if [ $a != $b ]; then
        echo MD5 mismatch, $a - $b trying again
        b=$(ssh user@$NAS_IP -p PORT "md5sum $NAS_VOLUME/$n.bag|cut -f 1 -d ' '") # update this folder on NAS vokume change
        echo MD5 calculated again: $b 
        echo $b >$n.nas.md5
        cp $n.info.txt /data/nas/
        mv $n.nas.md5 /data/nas/
    fi

    if [ $a == $b ]; then
        echo $n.bag uploaded, verified and deleted
        mv $n.bag /data/hdd/backup
        mv $n.info.txt /data/hdd/backup
        mv $n.hdd.md5 /data/hdd/backup
        touch /data/hdd/backup/$n.uploaded
    else
            report "WARNING: Rosbag upload failed on hive $HOSTNAME - MD5 $a  - $b"
    fi
else
    d=$(echo $HOSTNAME|grep -o [0-3])
    re='^[0-9]+$'
    if ! [[ $d =~ $re ]] ; then
       d=0 #$(shuf -i 0-3 -n 1)
       fi
    echo There were no fresh files to be moved $HOSTNAME
    sleep $(($d*360+1))
    ~/rr_os_setup/file_management/upload_bags_hdd.sh $NAS_IP $NAS_VOLUME
fi

cd $x
