#!/bin/bash
nvme_folder="/home/pc/rosbags"
hdd_folder="/data/hdd/"

for bag_name in `ls ${nvme_folder}`
do
if [[ "${bag_name}" != *"hash"* ]]; then
    md5sum "${nvme_folder}${bag_name}" >> "${nvme_folder}${bag_name}.hash"
    rsync -a "${nvme_folder}${bag_name}" "${hdd_folder}${bag_name}" 
    rsync -a --remove-source-files "${nvme_folder}${bag_name}" "${hdd_folder}${bag_name}" 
    rsync -a "${nvme_folder}${bag_name}.hash" "${hdd_folder}${bag_name}.hash" 
    rsync -a --remove-source-files "${nvme_folder}${bag_name}.hash" "${hdd_folder}${bag_name}.hash" 
fi
done

