/*
Software for the Autonomous Robotic Observation and Behavioral Analysis system. 

XY actuator high-level control

Copyright 2025 Tomas Krajnik 

Commercial use of the software requires written consent of the copyright holders. 
For Open Research and Educational use, the following applies:

Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements.  See the NOTICE file
distributed with this work for additional information
regarding copyright ownership.  The ASF licenses this file
to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.



*/




#include <ros/ros.h>
#include <stdio.h>
#include <image_transport/image_transport.h>
#include <string>
#include <std_msgs/String.h>
#include <time.h>
#include <cv_bridge/cv_bridge.h>
#include <sensor_msgs/image_encodings.h>
#include <opencv2/opencv.hpp>

#define QUEUE_LENGTH 700
#define SPEEDUP 6 

/*used to switch between combs*/
image_transport::Subscriber imageSub[2];

char discord[11000]; 
/*ros and image transport handles*/
image_transport::ImageTransport *it;
ros::NodeHandle *nh;
cv::Mat imageTrackArray[QUEUE_LENGTH];
cv::Mat imageMirrorArray[QUEUE_LENGTH];
ros::Timer timer; 
int queueTrackPos = 0;
int queueMirrorPos = 0;
int scale = 2;
int imageTick0 = 0;
int imageTick1 = 0;
int trackDuration = 0;
int mirrorDuration = 0;
ros::Subscriber xyStateSub[2];
std::string stateDescription[2];
int hive = 0; 
int side = 0;

const char keys[] = {"DISCORD WEBHOOK KEY GOES HERE"};

void sendVideo(int s) 
{
    sprintf(discord,"curl -v -H \"Authorization: Bot TOKEN\" -H \"User-Agent: GrazMasterPCBot http://roboroyale.eu, v0.1\" -H \"Content-Type: multipart/form-data\" -X POST -F \'payload_json=\{\"username\": \"Aggregator\", \"content\": \" Queen lost in hive %i at side %i\"}\' -F \"file1=@/home/pc/queenlost.mp4\" https://discord.com/api/webhooks/%s ",hive,s,keys);
    int a = system(discord);
}

int createVideo()
{

    cv::VideoWriter outputVideo;  // Open the output
    outputVideo.open("/home/pc/queenlost.mp4",cv::VideoWriter::fourcc('H','2','6','4'), 30, cv::Size(1920/scale,1080/scale), false);  //scale0 for 30 fps
    if (!outputVideo.isOpened()){
        ROS_ERROR("Could not open the output video for write: ");
        return -1;
    }

    for(int i=0/SPEEDUP; i<20*30/SPEEDUP; i++) outputVideo.write(imageTrackArray[(i+queueTrackPos)%QUEUE_LENGTH]);
    for(int i=20*30/SPEEDUP; i<120*30/SPEEDUP; i++) outputVideo.write(imageMirrorArray[(i+queueMirrorPos)%QUEUE_LENGTH]);
    outputVideo.release();
    
    return 0;
}

void stateCallback0(const std_msgs::StringConstPtr& msg)
{
    int n = 0;
    if (stateDescription[0] != "Track-queen" && stateDescription[1] != "Track-queen" && trackDuration > 0) {createVideo();sendVideo(1-n);} 
    if (stateDescription[0] == "Track-queen" || stateDescription[1] == "Track-queen") trackDuration++; else trackDuration = 0;
    stateDescription[n] = msg->data;
}

void stateCallback1(const std_msgs::StringConstPtr& msg)
{
    int n = 1;
    if (stateDescription[0] != "Track-queen" && stateDescription[1] != "Track-queen" && trackDuration > 0) {createVideo();sendVideo(1-n);} 
    if (stateDescription[0] == "Track-queen" || stateDescription[1] == "Track-queen") trackDuration++; else trackDuration = 0;
    stateDescription[n] = msg->data;
}


void processFrame(const sensor_msgs::ImageConstPtr& msg,cv::Mat imageArray[],int queuePos)
{
    cv_bridge::CvImagePtr cv_ptr;
    hive = msg->header.frame_id.c_str()[6]-'0';
    side = msg->header.frame_id.c_str()[11]-'0';
    //ROS_INFO("Image %s - %i %i",msg->header.frame_id.c_str(),h,s);
    resize(cv::Mat(1080, 1920,CV_8UC1, (void*)msg->data.data()),imageArray[queuePos], cv::Size(1920/scale, 1080/scale), cv::INTER_LINEAR);

    struct tm  tstruct;
    time_t     now = time(0);
    tstruct = *localtime(&now);
    char text[1000];
    char buf[100];
    strftime(buf, sizeof(buf), "%Y-%m-%d  %X", &tstruct);
    sprintf(text,"Hive %i, side %i at %s",hive,side,buf);
    putText(imageArray[queuePos],text, cv::Point(20,20), cv::FONT_HERSHEY_DUPLEX, 0.5, cv::Scalar(255), 1.0);
}

/*used to get pictures of comb with the honeybee queen*/
void mainImageCallback0(const sensor_msgs::ImageConstPtr& msg)
{
    if (imageTick0++%SPEEDUP == 0){
        if (stateDescription[0] == "Track-queen"){
            if (queueTrackPos < QUEUE_LENGTH) processFrame(msg,imageTrackArray,queueTrackPos);
            queueTrackPos++;
            if (queueTrackPos >= QUEUE_LENGTH) queueTrackPos = 0;
        }
        if (stateDescription[0] == "Mirror" || stateDescription[0] == "Queen_search"){ 
            if (queueMirrorPos < QUEUE_LENGTH) processFrame(msg,imageMirrorArray,queueMirrorPos);
            queueMirrorPos++;
            if (queueMirrorPos >= QUEUE_LENGTH) queueMirrorPos = 0;
        }
    }
}

void mainImageCallback1(const sensor_msgs::ImageConstPtr& msg)
{
    if (imageTick1++%SPEEDUP == 0){
        if (stateDescription[1] == "Track-queen"){ 
            if (queueTrackPos < QUEUE_LENGTH) processFrame(msg,imageTrackArray,queueTrackPos);
            queueTrackPos++;
            if (queueTrackPos >= QUEUE_LENGTH) queueTrackPos = 0;
        }
        if (stateDescription[1] == "Mirror" || stateDescription[1] == "Queen_search"){ 
            if (queueMirrorPos < QUEUE_LENGTH) processFrame(msg,imageMirrorArray,queueMirrorPos);
            queueMirrorPos++;
            if (queueMirrorPos >= QUEUE_LENGTH) queueMirrorPos = 0;
        }
    }
}


int main(int argc, char **argv)
{
	ros::init(argc, argv, "xy_queenlostvideo");
	for (int i = 0;i<QUEUE_LENGTH;i++){
	       	imageMirrorArray[i] = cv::Mat(1080/scale,1920/scale,CV_8UC1);
	       	imageTrackArray[i] = cv::Mat(1080/scale,1920/scale,CV_8UC1);
	}
	nh = new ros::NodeHandle();
	it = new image_transport::ImageTransport(*nh);

	char topicName[1000];
	sprintf(topicName,"xy_0/whycon/processed_image");
	sprintf(topicName,"xy_0/camera/image_mono");
	imageSub[0] = it->subscribe(topicName, 1,mainImageCallback0);
	sprintf(topicName,"xy_1/whycon/processed_image");
	sprintf(topicName,"xy_1/camera/image_mono");
	imageSub[1] = it->subscribe(topicName, 1,mainImageCallback1);

	sprintf(topicName,"xy_%i/state",0);
	xyStateSub[0] = nh->subscribe(topicName, 1,stateCallback0);
	sprintf(topicName,"xy_%i/state",1);
	xyStateSub[1] = nh->subscribe(topicName, 1,stateCallback1);

	ros::spin();
	return 0;
}


