# Software for the Autonomous Robotic Observation and Behavioral Analysis system
#
# XY actuator high-level control
#
# Copyright 2025 Tomas Krajnik 
#
# Commercial use of the software requires written consent of the copyright holders. 
#
# For Open Research and Educational use, the following applies:
#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at

#   http://www.apache.org/licenses/LICENSE-2.0

# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Tue Jul 11 10:21:04 2023

@author: frekabi
"""

from rr_msgs.msg import LEDArray

import board
# import neopixel
import neopixel_spi
import time
import rospy




class LED_ctrl():
    
    def __init__(self):
        rospy.init_node("Multi_Arm_CTL1")
        self.rate = rospy.Rate(100)
        
        self.led_num = 6
        
        
        #self.pixels = neopixel.NeoPixel(pin=board.D18, n=self.led_num+1, brightness=0.8, pixel_order="RGB")
        self.pixels = neopixel_spi.NeoPixel_SPI(board.SPI(), 8)
        
        
        rospy.Subscriber("/Multi_Arm_CTL/LED1", LEDArray, self.led_com_callback, queue_size=1)
        
        
        
        
        
        
        
        
        
    def led_com_callback(self,msg):
        
        
        for i in range(self.led_num):
            
            color = msg.leds[i]
            print('/rr_le_ctrl/led_clbk : the color is :%f %f %f %f'%(color.r,color.g,color.b,color.a))
            self.pixels[i].clear()
            #time.sleep(1)
            self.pixels[i] = (int(color.r * color.a), int(color.g * color.a), int(color.b * color.a)) 
            
        self.pixels.show()
        print('/rr_le_ctrl/led_clbk : color is set')
        
    def start(self):
        while not rospy.is_shutdown():
            continue
        
        
if __name__ == "__main__":
   LEDctrl = LED_ctrl()
   LEDctrl.start()
            
            
        
        
        



