# Software for the Autonomous Robotic Observation and Behavioral Analysis system
#
# XY actuator high-level control
#
# Copyright 2025 Tomas Krajnik 
#
# Commercial use of the software requires written consent of the copyright holders. 
#
# For Open Research and Educational use, the following applies:
#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at

#   http://www.apache.org/licenses/LICENSE-2.0

# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Tue Jul 11 13:33:53 2023

@author: frekabi
"""



from rr_msgs.msg import LEDArray

import time
import rospy


class RGBAColor():
    
    def __init__(self):
        self.r = 10
        self.g = 0
        self.b = 0
        self.a = 1


class LED_ROS_Test():
    
    
    
    def __init__(self):
        rospy.init_node("Multi_Arm_CTL0")
        self.rate = rospy.Rate(100)
        self.color = RGBAColor()
        self.led_publisher = rospy.Publisher("/Multi_Arm_CTL/LED1", LEDArray, queue_size=1)
        self.led_data = LEDArray()
        
        self.color2 = []
        self.led_num = 7
        for i in range(self.led_num):
            # self.color.r = 10
            # self.color.g = i*5
            # self.color.b = 0
            # self.color.a = 1
            # self.led_data.leds.append(self.color) 
            # self.color2.append(self.color)
            self.led_data.leds.append(RGBAColor())
            self.led_data.leds[i].r = 0
            self.led_data.leds[i].g = 0
            self.led_data.leds[i].b = 0
            self.led_data.leds[i].a = 1
            #print(self.color2)
            
            
            #self.led_data.leds[i] = 0
            #self.led_data.leds[i] = 0
            #self.led_data.leds[i] = 1
        #self.led_data.leds = self.color2
        #print(len(self.led_data.leds))
        print('The rgba values for 1 are: %f, %f, %f, %f '%(self.led_data.leds[1].r,self.led_data.leds[1].g,self.led_data.leds[1].b,self.led_data.leds[1].a))
        print('The rgba values for 2 are: %f, %f, %f, %f '%(self.led_data.leds[2].r,self.led_data.leds[2].g,self.led_data.leds[2].b,self.led_data.leds[2].a))
        print('The rgba values for 3 are: %f, %f, %f, %f '%(self.led_data.leds[3].r,self.led_data.leds[3].g,self.led_data.leds[3].b,self.led_data.leds[3].a))
        # print('The rgba values for 1 are: %f, %f, %f, %f '%(self.color2[1].r,self.color2[1].g,self.color2[1].b,self.color2[1].a))
        # print('The rgba values for 2 are: %f, %f, %f, %f '%(self.color2[2].r,self.color2[2].g,self.color2[2].b,self.color2[2].a))
        
        
    def set_led_com(self,r,g,b,a,i):
        
        for k in range(len(self.led_data.leds)):
            if k == i:
                self.led_data.leds[k].r = r
                self.led_data.leds[k].g = g
                self.led_data.leds[k].b = b
                self.led_data.leds[k].a = a
                
        
        
        print('The rgba values are set as: %f, %f, %f, %f '%(self.led_data.leds[i].r,self.led_data.leds[i].g,self.led_data.leds[i].b,self.led_data.leds[i].a))
        
        print('The rgba values for 1 are: %f, %f, %f, %f '%(self.led_data.leds[1].r,self.led_data.leds[1].g,self.led_data.leds[1].b,self.led_data.leds[1].a))
        
        
    def main(self):
        
        while not rospy.is_shutdown():
            
            i = int(input('enter the led number: '))
            r = int(input('enter the red value: '))
            g = int(input('enter the green value: '))
            b = int(input('enter the blue value: '))
            a = int(input('enter the intensity value: '))
            
            self.set_led_com(r, g, b, a, i)
            
            self.led_publisher.publish(self.led_data)
            

if __name__ == "__main__":
   led_test = LED_ROS_Test()
   led_test.main()
        
        
    