# Software for the Autonomous Robotic Observation and Behavioral Analysis system
#
# XY actuator high-level control
#
# Copyright 2025 Tomas Krajnik 
#
# Commercial use of the software requires written consent of the copyright holders. 
#
# For Open Research and Educational use, the following applies:
#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at

#   http://www.apache.org/licenses/LICENSE-2.0

# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Mon Jun 26 11:30:26 2023

@author: frekabi
"""

from LA_drive import LA_drive
from Servo_drive import Servo_drive
import rospy
from geometry_msgs.msg import PoseStamped, Pose, Twist 
import sys, select, os
import tty, termios
from std_msgs.msg import String
import math
import time
from sensor_msgs.msg import JointState
try:
    from ServoPi import PWM
    from ServoPi import Servo
except ImportError:
    print("Failed to import ServoPi from python system path")
    print("Importing from parent folder instead")
    try:
        import sys
        sys.path.append("..")
        from ServoPi import PWM
    except ImportError:
        raise ImportError(
            "Failed to import library from parent folder")





class Multi_Arm_Management:
    
    def __init__(self):
        
        rospy.init_node("Multi_Arm_drv2")
        
        
        self.lin_act = Servo(0x40)
        # self.ch = chan
        # # Set PWM frequency to 1 Khz and enable the output
        # self.d_pos = 0.19 #According to the measurement for the LA (in mm) 0.19/step 
        self.lin_act.set_frequency(50)
        self.lin_act.set_low_limit(1.0)
        self.lin_act.set_high_limit(2.0)
        
        
        self.rot1 = LA_drive(16, self.lin_act)
        time.sleep(0.1)
        self.rot2 = LA_drive(15, self.lin_act)
        time.sleep(0.1)
        self.rot3 = LA_drive(14, self.lin_act)
        time.sleep(0.1)
        self.rot4 = LA_drive(13, self.lin_act)
        time.sleep(0.1)
        self.rot5 = LA_drive(12, self.lin_act)
        time.sleep(0.1)
        self.rot6 = LA_drive(11, self.lin_act)
        time.sleep(0.1)
        self.la1 = LA_drive(1, self.lin_act) # we can use the command_imp attribute to send a command between 0 to 100 and sat(self,val,min_val,max_val) to saturate the inputs
        time.sleep(0.1)
        self.la2 = LA_drive(2, self.lin_act)
        time.sleep(0.1)
        self.la3 = LA_drive(3, self.lin_act)
        time.sleep(0.1)
        self.la4 = LA_drive(4, self.lin_act)
        time.sleep(0.1)
        self.la5 = LA_drive(5, self.lin_act)
        time.sleep(0.1)
        self.la6 = LA_drive(6, self.lin_act)
        time.sleep(0.1)
        
        
        self.servo_act = Servo(0x41)
        self.servo_act.set_frequency(50)
        self.servo_act.set_low_limit(1.0)
        self.servo_act.set_high_limit(2.0)
        
        self.m_serv0 = Servo_drive(16, self.servo_act)
        self.m_serv1 = Servo_drive(1, self.servo_act)
        self.m_serv2 = Servo_drive(2, self.servo_act)
        self.m_serv3 = Servo_drive(3, self.servo_act)
        self.m_serv4 = Servo_drive(4, self.servo_act)
        self.m_serv5 = Servo_drive(5, self.servo_act)
        self.m_serv6 = Servo_drive(6, self.servo_act)
        
        #self.rot1 = LA_drive(7) # we can use the command_imp attribute to send a command between 0 to 100 and sat(self,val,min_val,max_val) to saturate the inputs
        
          
        rospy.Subscriber("/Multi_Arm_CTL/ACT_Com", JointState, self.mam_com_callback, queue_size=1)
        
        
        self.rate = rospy.Rate(100)
        self.key = ''
        
        self.JointList = [{'name':'main_servo','min_val':0,'max_va':359},
                          {'name':'Arm1_Mserv','min_val':0,'max_va':33.5}]
        
        
        
        self.Mserv_max = 45
        
        
        
    def mam_com_callback(self,msg):
        self.cmd_name = msg.name
        self.cmd_pos = msg.position
        print('received msg is:' + str(self.cmd_name))
        
        for name in self.cmd_name:
            
            if name == 'main_servo':
                com = self.cmd_pos[0]
                com_sat = self.m_serv0.sat(com, 0, 360)
                com_app = self.m_serv0.rot_srv_conv(com_sat)
                self.m_serv0.command_imp(com_app)
            
            if name == 'Arm1_Mserv':
                com = self.cmd_pos[1]
                com_sat = self.m_serv1.sat(com, 1, self.Mserv_max)
                com_app = self.m_serv1.m_srv_conv(com_sat)
                self.m_serv1.command_imp(com_app)
                
            elif name == 'Arm1_LA':
                com = self.cmd_pos[2]
                com_sat = self.la1.sat(com, 0, 15.2)
                com_app = self.la1.la_conv(com_sat)
                self.la1.command_imp(com_app)
                
            elif name == 'Arm1_rot':
                com = self.cmd_pos[3]
                com_sat = self.rot1.sat(com, 0, 180)
                com_app = self.rot1.rot_conv(com_sat)
                self.rot1.command_imp(com_app)
                
            elif name == 'Arm2_Mserv':
                com = self.cmd_pos[4]
                com_sat = self.m_serv2.sat(com, 1, self.Mserv_max)
                com_app = self.m_serv2.m_srv_conv(com_sat)
                self.m_serv2.command_imp(com_app)
                
            elif name == 'Arm2_LA':
                com = self.cmd_pos[5]
                com_sat = self.la2.sat(com, 0, 15.2)
                com_app = self.la2.la_conv(com_sat)
                self.la2.command_imp(com_app)
                
            elif name == 'Arm2_rot':
                com = self.cmd_pos[6]
                com_sat = self.rot2.sat(com, 0, 180)
                com_app = self.rot2.rot_conv(com_sat)
                self.rot2.command_imp(com_app)
                
            elif name == 'Arm3_Mserv':
                com = self.cmd_pos[7]
                com_sat = self.m_serv3.sat(com, 1, self.Mserv_max)
                com_app = self.m_serv3.m_srv_conv(com_sat)
                self.m_serv3.command_imp(com_app)
                
            elif name == 'Arm3_LA':
                com = self.cmd_pos[8]
                com_sat = self.la3.sat(com, 0, 15.2)
                com_app = self.la3.la_conv(com_sat)
                self.la3.command_imp(com_app)
                
                
            elif name == 'Arm3_rot':
                com = self.cmd_pos[9]
                com_sat = self.rot3.sat(com, 0, 180)
                com_app = self.rot3.rot_conv(com_sat)
                self.rot3.command_imp(com_app)
                
            elif name == 'Arm4_Mserv':
                com = self.cmd_pos[10]
                com_sat = self.m_serv4.sat(com, 1, self.Mserv_max)
                com_app = self.m_serv4.m_srv_conv(com_sat)
                self.m_serv4.command_imp(com_app)
                
            elif name == 'Arm4_LA':
                com = self.cmd_pos[11]
                com_sat = self.la4.sat(com, 0, 15.2)
                com_app = self.la4.la_conv(com_sat)
                self.la4.command_imp(com_app)
                
                
            elif name == 'Arm4_rot':
                com = self.cmd_pos[12]
                com_sat = self.rot4.sat(com, 0, 180)
                com_app = self.rot4.rot_conv(com_sat)
                self.rot4.command_imp(com_app)
                    
            elif name == 'Arm5_Mserv':
                com = self.cmd_pos[13]
                com_sat = self.m_serv5.sat(com, 1, self.Mserv_max)
                com_app = self.m_serv5.m_srv_conv(com_sat)
                self.m_serv5.command_imp(com_app)
                
            elif name == 'Arm5_LA':
                com = self.cmd_pos[14]
                com_sat = self.la5.sat(com, 0, 15.2)
                com_app = self.la5.la_conv(com_sat)
                self.la5.command_imp(com_app)
                
            elif name == 'Arm5_rot':
                com = self.cmd_pos[15]
                com_sat = self.rot5.sat(com, 0, 180)
                com_app = self.rot5.rot_conv(com_sat)
                self.rot5.command_imp(com_app)
            
            elif name == 'Arm6_Mserv':
                com = self.cmd_pos[16]
                com_sat = self.m_serv6.sat(com, 1, self.Mserv_max)
                com_app = self.m_serv6.m_srv_conv(com_sat)
                self.m_serv6.command_imp(com_app)
                
            elif name == 'Arm6_LA':
                com = self.cmd_pos[17]
                com_sat = self.la6.sat(com, 0, 15.2)
                com_app = self.la6.la_conv(com_sat)
                self.la6.command_imp(com_app)
                
            elif name == 'Arm6_rot':
                com = self.cmd_pos[18]
                com_sat = self.rot6.sat(com, 0, 180)
                com_app = self.rot6.rot_conv(com_sat)
                self.rot6.command_imp(com_app)
           
            
        
    def main(self):
        while not rospy.is_shutdown():
            continue
        
        
        
        
if __name__ == "__main__":
    ma_mng = Multi_Arm_Management()
    ma_mng.main()
