# Software for the Autonomous Robotic Observation and Behavioral Analysis system
#
# XY actuator high-level control
#
# Copyright 2025 Tomas Krajnik 
#
# Commercial use of the software requires written consent of the copyright holders. 
#
# For Open Research and Educational use, the following applies:
#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at

#   http://www.apache.org/licenses/LICENSE-2.0

# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Tue Jun 20 08:15:33 2023

@author: frekabi
"""
from __future__ import absolute_import, division, print_function, \
                                                    unicode_literals
import time

try:
    from ServoPi import PWM
    from ServoPi import Servo
except ImportError:
    print("Failed to import ServoPi from python system path")
    print("Importing from parent folder instead")
    try:
        import sys
        sys.path.append("..")
        from ServoPi import PWM
    except ImportError:
        raise ImportError(
            "Failed to import library from parent folder")


#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Fri Jan 13 11:57:49 2023

@author: frekabi
"""

#!/usr/bin/env python
"""
================================================
AB Electronics UK Servo Pi PWM controller | PWM output demo

run with: python demo_pwm.py
================================================

This demo shows how to set a 1KHz output frequency and change the pulse width
between the minimum and maximum values
"""


        
        
class Servo_drive():
    
    def __init__(self,chan,servo):
        # Set the i2c chanel according to the jumpers on the board
        # self.servo = Servo(0x41)
        self.ch = chan
        # # Set PWM frequency to 1 Khz and enable the output
        self.d_pos = 0.19 #According to the measurement for the LA (in mm) 0.19/step 
        # self.servo.set_frequency(50)
        # self.servo.set_low_limit(1.0)
        # self.servo.set_high_limit(2.0)
        self.servo = servo
        
        self.des_pos = 0
        srv_c1 = self.m_srv_conv(self.des_pos)
        
        self.command_imp(srv_c1)
        
                
        self.servo_com1 = 10
        
        self.full_rng_step = 120
        
        
        
        
        
    def command_imp(self,servo_com) :
        
        self.servo.move(self.ch,servo_com,self.full_rng_step)
        print('Servo Chanel is: %f, and the command is: %f'%(self.ch,servo_com))
        
    def sat(self,val,min_val,max_val):
        
        sat_val = min(max(val,min_val),max_val)
        return sat_val
    
    def m_srv_conv(self,pos_des):
        self.full_rng_step = 120
        srv_c1 = 1.47 * pos_des + 40
        return srv_c1
    
    def rot_srv_conv(self,pos_des):
        self.full_rng_step = 360
        srv_c1 = pos_des 
        return srv_c1
        
        
        
        
  


    def main(self):
        """
        Main program function
        """
        ####################################################
        ###############Initialization######################
        #self.command_imp(self.servo_com1)
        srv_c1 = self.m_srv_conv(self.des_pos)
        
        self.command_imp(srv_c1)
        #####################################################
        print('Initialization is completed')
        
        while True:
              try:
                  self.des_pos = float(input('Enter the desired position: '))
                  #self.com_pos = self.sat(self.des_pos, 0, 15.2) # This is the range measured for the linear behaviour (the full linear range is 15.2mm)
                                  
                  
                  #srv_c1 = self.full_rng_step - self.com_pos / self.d_pos
                  srv_c1 = self.m_srv_conv(self.des_pos)
                  
                  self.command_imp(srv_c1)
                 
                  
                  print('servo1 is: %f' %(srv_c1))
                  
                  # time.sleep(1)
                     
              except KeyboardInterrupt :
                  break

if __name__ == "__main__":
    chn = int(input('Enter the chanel number: '))
    servo = Servo(0x41)
     
    servo.set_frequency(50)
    servo.set_low_limit(1.0)
    servo.set_high_limit(2.0)
    test_ee = Servo_drive(chn,servo)
    test_ee.main()
