# Software for the Autonomous Robotic Observation and Behavioral Analysis system
#
# XY actuator high-level control
#
# Copyright 2025 Tomas Krajnik 
#
# Commercial use of the software requires written consent of the copyright holders. 
#
# For Open Research and Educational use, the following applies:
#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at

#   http://www.apache.org/licenses/LICENSE-2.0

# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Thu Jun 22 09:42:44 2023

@author: frekabi
"""


import tkinter as tk
from tkinter import ttk
import time
import math

import rospy

from sensor_msgs.msg import JointState

import math
import time

class windows(tk.Tk):
    def __init__(self, *args, **kwargs):
        tk.Tk.__init__(self, *args, **kwargs)
        # Adding a title to the window
        self.wm_title("Test Application")
        rospy.init_node("Multi_Arm_CTL")
        self.rate = rospy.Rate(100)
        

        # creating a frame and assigning it to container
        container = tk.Frame(self, height=1200, width=1000)
        # specifying the region where the frame is packed in root
        container.pack(side="top", fill="both", expand=True)
        

        # configuring the location of the container using grid
        container.grid_rowconfigure(0, weight=1)
        container.grid_columnconfigure(0, weight=1)

        # We will now create a dictionary of frames
        self.frames = {}
        # we'll create the frames themselves later but let's add the components to the dictionary.
        for F in (MainPage, SidePage, CompletionScreen):
            frame = F(container, self)

            # the windows class acts as the root window for the frames.
            self.frames[F] = frame
            frame.grid(row=0, column=0, sticky="nsew")

        # Using a method to switch frames
        self.show_frame(MainPage)
        
        





    def show_frame(self, cont):
        frame = self.frames[cont]
        # raises the current frame to the top
        frame.tkraise()




class MainPage(tk.Frame):
    def __init__(self, parent, controller):
        tk.Frame.__init__(self, parent)
        label = tk.Label(self, text="Main Page")
        label.pack(padx=10, pady=10)
        
        self.serv_max = 45
        self.la_max = 15
        self.tot_max = 180
        
        self.arm1_servo_pos = 0
        self.arm1_la_pos = 0
        self.arm1_rot = 0
        
        self.arm2_servo_pos = 0
        self.arm2_la_pos = 0
        self.arm2_rot = 0
        
        self.arm3_servo_pos = 0
        self.arm3_la_pos = 0
        self.arm3_rot = 0
        
        self.arm4_servo_pos = 0
        self.arm4_la_pos = 0
        self.arm4_rot = 0
        
        self.arm5_servo_pos = 0
        self.arm5_la_pos = 0
        self.arm5_rot = 0
        
        self.arm6_servo_pos = 0
        self.arm6_la_pos = 0
        self.arm6_rot = 0
                
        self.alpha = math.pi * 0
        
        self.rate = rospy.Rate(100)
        
        
        
        self.multiarm_com_pub = rospy.Publisher("/Multi_Arm_CTL/ACT_Com", JointState, queue_size=1) # The ros topic for the rotating base actuator command
        self.multi_arm_com = JointState()
        self.multi_arm_com.name = []
        self.multi_arm_com.position = [self.alpha,self.arm1_servo_pos,self.arm1_la_pos,self.arm1_rot,self.arm2_servo_pos,self.arm2_la_pos,self.arm2_rot,self.arm3_servo_pos,self.arm3_la_pos,self.arm3_rot,self.arm4_servo_pos,self.arm4_la_pos,self.arm4_rot,self.arm5_servo_pos,self.arm5_la_pos,self.arm5_rot,self.arm6_servo_pos,self.arm6_la_pos,self.arm6_rot] 
        
        ####################### Arm Main Servo Command ###########################
        var0 = tk.DoubleVar(self)
        self.main_scale = tk.Scale(self, variable= var0, label='Main Servo Command', orient='horizontal',sliderlength=20, length=200, from_=0, to=360, resolution=1, command=self.main_scale_ch)   
        self.main_scale.pack(anchor='center',side='left')
        self.main_scale.place(x=20,y=700)
        
        self.main_val = tk.Entry(self)
        self.main_val.pack(side='left')
        self.main_val.place(x=230,y=740, width=50, height=20)
        
        self.main_com_apply = tk.Button(self, text='Apply rotaion', bg= 'yellow', command=self.main_ent_ch)
        self.main_com_apply.pack(side='left')
        self.main_com_apply.place(x=180,y=760,width=100,height=50)
        
        #######################################################################
        
        
        
        ####################### Arm 1 Servo Command ###########################
        var = tk.DoubleVar(self)
        self.arm1_scale = tk.Scale(self, variable= var, label='Arm1 Servo', orient='horizontal',sliderlength=20, length=200, from_=0, to=self.serv_max , resolution=0.5, command=self.arm1_scale_ch)   
        self.arm1_scale.pack(anchor='center',side='left')
        self.arm1_scale.place(x=0,y=0)
        
        self.arm1_val = tk.Entry(self)
        self.arm1_val.pack(side='left')
        self.arm1_val.place(x=210,y=40,width=50,height=20)
        
        self.arm1_com_apply = tk.Button(self, text='Apply Servo', bg= '#E6B0AA', command=self.arm1_ent_ch)
        self.arm1_com_apply.pack(side='left')
        self.arm1_com_apply.place(x=160,y=60,width=100,height=25)
        
        #######################################################################
        
        ####################### Arm 1 LA Command ###########################
        var = tk.DoubleVar(self)
        self.arm1_la_scale = tk.Scale(self, variable= var, label='Arm1 LA', orient='horizontal',sliderlength=20, length=200, from_=0, to=self.la_max, resolution=0.2, command=self.arm1_la_scale_ch)   
        self.arm1_la_scale.pack(anchor='center',side='left')
        self.arm1_la_scale.place(x=0,y=90)
        
        self.arm1_la_val = tk.Entry(self)
        self.arm1_la_val.pack(side='left')
        self.arm1_la_val.place(x=210,y=130,width=50,height=20)
        
        self.arm1_la_com_apply = tk.Button(self, text='Apply LA', bg= '#A93226', command=self.arm1_la_ent_ch)
        self.arm1_la_com_apply.pack(side='left')
        self.arm1_la_com_apply.place(x=160,y=150,width=100,height=25)
        
        #######################################################################
        
        ####################### Arm 1 Rotation Command ########################
        var = tk.DoubleVar(self)
        self.arm1_rot_scale = tk.Scale(self, variable= var, label='Arm1 Rot', orient='vertical',sliderlength=20, length=150, from_=0, to=180, resolution=5, command=self.arm1_rot_scale_ch)   
        self.arm1_rot_scale.pack(anchor='center',side='left')
        self.arm1_rot_scale.place(x=270,y=20)
        
        self.arm1_rot_val = tk.Entry(self)
        self.arm1_rot_val.pack(side='left')
        self.arm1_rot_val.place(x=350,y=50,width=50,height=20)
        
        self.arm1_rot_com_apply = tk.Button(self, text='Apply Rot', bg= '#A93226', command=self.arm1_rot_ent_ch)
        self.arm1_rot_com_apply.pack(side='left')
        self.arm1_rot_com_apply.place(x=350,y=70,width=100,height=25)
        
        #######################################################################
        
        ####################### Arm 2 Servo Command ###########################
        var2 = tk.DoubleVar(self)
        self.arm2_scale = tk.Scale(self, variable= var2, label='Arm2 Servo', orient='horizontal',sliderlength=20, length=200, from_=0, to=self.serv_max, resolution=0.5, command=self.arm2_scale_ch)   
        self.arm2_scale.pack(anchor='center',side='left')
        self.arm2_scale.place(x=0,y=200)
        
        self.arm2_val = tk.Entry(self)
        self.arm2_val.pack(side='left')
        self.arm2_val.place(x=210,y=240,width=50,height=25)
        
        self.arm2_com_apply = tk.Button(self, text='Apply Servo', bg= '#D7BDE2', command=self.arm2_ent_ch)
        self.arm2_com_apply.pack(side='left')
        self.arm2_com_apply.place(x=160,y=260,width=100,height=25)
        
        #######################################################################
        
        ####################### Arm 2 LA Command ###########################
        var2 = tk.DoubleVar(self)
        self.arm2_la_scale = tk.Scale(self, variable= var2, label='Arm2 LA', orient='horizontal',sliderlength=20, length=200, from_=0, to=self.la_max, resolution=0.2, command=self.arm2_la_scale_ch)   
        self.arm2_la_scale.pack(anchor='center',side='left')
        self.arm2_la_scale.place(x=0,y=290)
        
        self.arm2_la_val = tk.Entry(self)
        self.arm2_la_val.pack(side='left')
        self.arm2_la_val.place(x=210,y=330, width=50, height=20)
        
        self.arm2_la_com_apply = tk.Button(self, text='Apply LA', bg= '#76448A', command=self.arm2_la_ent_ch)
        self.arm2_la_com_apply.pack(side='left')
        self.arm2_la_com_apply.place(x=160,y=350,width=100,height=25)
        
        #######################################################################
        
        ####################### Arm 2 Rotation Command ########################
        var2 = tk.DoubleVar(self)
        self.arm2_rot_scale = tk.Scale(self, variable= var2, label='Arm2 Rot', orient='vertical',sliderlength=20, length=150, from_=0, to=180, resolution=5, command=self.arm2_rot_scale_ch)   
        self.arm2_rot_scale.pack(anchor='center',side='left')
        self.arm2_rot_scale.place(x=270,y=220)
        
        self.arm2_rot_val = tk.Entry(self)
        self.arm2_rot_val.pack(side='left')
        self.arm2_rot_val.place(x=350,y=250, width=50, height=20)
        
        self.arm2_rot_com_apply = tk.Button(self, text='Apply Rot', bg= '#76448A', command=self.arm2_rot_ent_ch)
        self.arm2_rot_com_apply.pack(side='left')
        self.arm2_rot_com_apply.place(x=350,y=270,width=100,height=25)
        
        #######################################################################
        
        ####################### Arm 3 Servo Command ###########################
        var3 = tk.DoubleVar(self)
        self.arm3_scale = tk.Scale(self, variable= var3, label='Arm3 Servo', orient='horizontal',sliderlength=20, length=200, from_=0, to=self.serv_max, resolution=0.5, command=self.arm3_scale_ch)   
        self.arm3_scale.pack(anchor='center',side='left')
        self.arm3_scale.place(x=0,y=400)
        
        self.arm3_val = tk.Entry(self)
        self.arm3_val.pack(side='left')
        self.arm3_val.place(x=210,y=440,width=50,height=20)
        
        self.arm3_com_apply = tk.Button(self, text='Apply Servo', bg= '#5DADE2', command=self.arm3_ent_ch)
        self.arm3_com_apply.pack(side='left')
        self.arm3_com_apply.place(x=160,y=460,width=100,height=25)
        
        #######################################################################
        
        ####################### Arm 3 LA Command ###########################
        var3 = tk.DoubleVar(self)
        self.arm3_la_scale = tk.Scale(self, variable= var3, label='Arm3 LA', orient='horizontal',sliderlength=20, length=200, from_=0, to=self.la_max, resolution=0.2, command=self.arm3_la_scale_ch)   
        self.arm3_la_scale.pack(anchor='center',side='left')
        self.arm3_la_scale.place(x=0,y=490)
        
        self.arm3_la_val = tk.Entry(self)
        self.arm3_la_val.pack(side='left')
        self.arm3_la_val.place(x=210,y=530,width=50,height=20)
        
        self.arm3_la_com_apply = tk.Button(self, text='Apply LA', bg= '#21618C', command=self.arm3_la_ent_ch)
        self.arm3_la_com_apply.pack(side='left')
        self.arm3_la_com_apply.place(x=160,y=550,width=100,height=25)
        
        #######################################################################
        
        ####################### Arm 3 Rotation Command ########################
        var3 = tk.DoubleVar(self)
        self.arm3_rot_scale = tk.Scale(self, variable= var3, label='Arm3 Rot', orient='vertical',sliderlength=20, length=150, from_=0, to=180, resolution=5, command=self.arm3_rot_scale_ch)   
        self.arm3_rot_scale.pack(anchor='center',side='left')
        self.arm3_rot_scale.place(x=270,y=420)
        
        self.arm3_rot_val = tk.Entry(self)
        self.arm3_rot_val.pack(side='left')
        self.arm3_rot_val.place(x=350,y=460,width=50,height=20)
        
        self.arm3_rot_com_apply = tk.Button(self, text='Apply LA', bg= '#21618C', command=self.arm3_rot_ent_ch)
        self.arm3_rot_com_apply.pack(side='left')
        self.arm3_rot_com_apply.place(x=350,y=480,width=100,height=25)
        
        #######################################################################
        
        
        ####################### Arm 4 Servo Command ###########################
        var4 = tk.DoubleVar(self)
        self.arm4_scale = tk.Scale(self, variable= var4, label='Arm4 Servo', orient='horizontal',sliderlength=20, length=200, from_=0, to=self.serv_max, resolution=0.5, command=self.arm4_scale_ch)   
        self.arm4_scale.pack(anchor='center',side='left')
        self.arm4_scale.place(x=720,y=0)
        
        self.arm4_val = tk.Entry(self)
        self.arm4_val.pack(side='left')
        self.arm4_val.place(x=930,y=40,width=50,height=20)
        
        self.arm4_com_apply = tk.Button(self, text='Apply Servo', bg= '#58D68D', command=self.arm4_ent_ch)
        self.arm4_com_apply.pack(side='left')
        self.arm4_com_apply.place(x=890,y=60,width=100,height=25)
        
        #######################################################################
        
        ####################### Arm 4 LA Command ###########################
        var4 = tk.DoubleVar(self)
        self.arm4_la_scale = tk.Scale(self, variable= var4, label='Arm4 LA', orient='horizontal',sliderlength=20, length=200, from_=0, to=self.la_max, resolution=0.2, command=self.arm4_la_scale_ch)   
        self.arm4_la_scale.pack(anchor='center',side='left')
        self.arm4_la_scale.place(x=720,y=90)
        
        self.arm4_la_val = tk.Entry(self)
        self.arm4_la_val.pack(side='left')
        self.arm4_la_val.place(x=930,y=130,width=50,height=20)
        
        self.arm4_la_com_apply = tk.Button(self, text='Apply LA', bg= '#1D8348', command=self.arm4_la_ent_ch)
        self.arm4_la_com_apply.pack(side='left')
        self.arm4_la_com_apply.place(x=890,y=150,width=100,height=25)
        
        #######################################################################
        
        ####################### Arm 4 Rotation Command ########################
        var4 = tk.DoubleVar(self)
        self.arm4_rot_scale = tk.Scale(self, variable= var4, label='Arm4 rot', orient='vertical',sliderlength=20, length=150, from_=0, to=180, resolution=5, command=self.arm4_rot_scale_ch)   
        self.arm4_rot_scale.pack(anchor='center',side='left')
        self.arm4_rot_scale.place(x=990,y=20)
        
        self.arm4_rot_val = tk.Entry(self)
        self.arm4_rot_val.pack(side='left')
        self.arm4_rot_val.place(x=1070,y=70,width=50,height=20)
        
        self.arm4_rot_com_apply = tk.Button(self, text='Apply Rot', bg= '#1D8348', command=self.arm4_rot_ent_ch)
        self.arm4_rot_com_apply.pack(side='left')
        self.arm4_rot_com_apply.place(x=1070,y=90,width=100,height=25)
        
        #######################################################################
        
        
        ####################### Arm 5 Servo Command ###########################
        var5 = tk.DoubleVar(self)
        self.arm5_scale = tk.Scale(self, variable= var5, label='Arm5 Servo', orient='horizontal',sliderlength=20, length=200, from_=0, to=self.serv_max, resolution=0.5, command=self.arm5_scale_ch)   
        self.arm5_scale.pack(anchor='center',side='left')
        self.arm5_scale.place(x=720,y=200)
        
        self.arm5_val = tk.Entry(self)
        self.arm5_val.pack(side='left')
        self.arm5_val.place(x=930,y=240,width=50,height=20)
        
        self.arm5_com_apply = tk.Button(self, text='Apply Servo', bg= '#F8C471', command=self.arm5_ent_ch)
        self.arm5_com_apply.pack(side='left')
        self.arm5_com_apply.place(x=890,y=260,width=100,height=25)
        
        #######################################################################
        
        ####################### Arm 5 LA Command ###########################
        var5 = tk.DoubleVar(self)
        self.arm5_la_scale = tk.Scale(self, variable= var5, label='Arm5 LA', orient='horizontal',sliderlength=20, length=200, from_=0, to=self.la_max, resolution=0.2, command=self.arm5_la_scale_ch)   
        self.arm5_la_scale.pack(anchor='center',side='left')
        self.arm5_la_scale.place(x=720,y=290)
        
        self.arm5_la_val = tk.Entry(self)
        self.arm5_la_val.pack(side='left')
        self.arm5_la_val.place(x=930,y=330,width=50,height=20)
        
        self.arm5_la_com_apply = tk.Button(self, text='Apply LA', bg= '#A04000', command=self.arm5_la_ent_ch)
        self.arm5_la_com_apply.pack(side='left')
        self.arm5_la_com_apply.place(x=890,y=350,width=100,height=25)
        
        #######################################################################
        
        ####################### Arm 5 Rotation Command ########################
        var5 = tk.DoubleVar(self)
        self.arm5_rot_scale = tk.Scale(self, variable= var5, label='Arm5 Rot', orient='vertical',sliderlength=20, length=150, from_=0, to=180, resolution=5, command=self.arm5_rot_scale_ch)   
        self.arm5_rot_scale.pack(anchor='center',side='left')
        self.arm5_rot_scale.place(x=990,y=220)
        
        self.arm5_rot_val = tk.Entry(self)
        self.arm5_rot_val.pack(side='left')
        self.arm5_rot_val.place(x=1070,y=270,width=50,height=20)
        
        self.arm5_rot_com_apply = tk.Button(self, text='Apply LA', bg= '#A04000', command=self.arm5_rot_ent_ch)
        self.arm5_rot_com_apply.pack(side='left')
        self.arm5_rot_com_apply.place(x=1070,y=290,width=100,height=25)
        
        #######################################################################
        
        
        ####################### Arm 6 Servo Command ###########################
        var6 = tk.DoubleVar(self)
        self.arm6_scale = tk.Scale(self, variable= var6, label='Arm6 Servo', orient='horizontal',sliderlength=20, length=200, from_=0, to=self.serv_max, resolution=0.5, command=self.arm6_scale_ch)   
        self.arm6_scale.pack(anchor='center',side='left')
        self.arm6_scale.place(x=720,y=400)
        
        self.arm6_val = tk.Entry(self)
        self.arm6_val.pack(side='left')
        self.arm6_val.place(x=930,y=440,width=50,height=20)
        
        self.arm6_com_apply = tk.Button(self, text='Apply Servo', bg= '#85929E', command=self.arm6_ent_ch)
        self.arm6_com_apply.pack(side='left')
        self.arm6_com_apply.place(x=890,y=460,width=100,height=25)
        
        #######################################################################
        
        ####################### Arm 6 LA Command ###########################
        var6 = tk.DoubleVar(self)
        self.arm6_la_scale = tk.Scale(self, variable= var6, label='Arm6 LA', orient='horizontal',sliderlength=20, length=200, from_=0, to=self.la_max, resolution=0.2, command=self.arm6_la_scale_ch)   
        self.arm6_la_scale.pack(anchor='center',side='left')
        self.arm6_la_scale.place(x=720,y=490)
        
        self.arm6_la_val = tk.Entry(self)
        self.arm6_la_val.pack(side='left')
        self.arm6_la_val.place(x=930,y=530,width=50,height=20)
        
        self.arm6_la_com_apply = tk.Button(self, text='Apply LA', bg= '#2E4053', command=self.arm6_la_ent_ch)
        self.arm6_la_com_apply.pack(side='left')
        self.arm6_la_com_apply.place(x=890,y=550,width=100,height=25)
        
        #######################################################################
        
        ####################### Arm 6 Rotation Command ########################
        var6 = tk.DoubleVar(self)
        self.arm6_rot_scale = tk.Scale(self, variable= var6, label='Arm6 Rot', orient='vertical',sliderlength=20, length=150, from_=0, to=180, resolution=5, command=self.arm6_rot_scale_ch)   
        self.arm6_rot_scale.pack(anchor='center',side='left')
        self.arm6_rot_scale.place(x=990,y=420)
        
        self.arm6_rot_val = tk.Entry(self)
        self.arm6_rot_val.pack(side='left')
        self.arm6_rot_val.place(x=1070,y=470,width=50,height=20)
        
        self.arm6_rot_com_apply = tk.Button(self, text='Apply Rot', bg= '#2E4053', command=self.arm6_rot_ent_ch)
        self.arm6_rot_com_apply.pack(side='left')
        self.arm6_rot_com_apply.place(x=1070,y=490,width=100,height=25)
        
        #######################################################################
                
        
        ######################### Display Canvas ##############################
        self.display = tk.Canvas(self, bg='blue', height=400, width=400)
        self.display.pack(side='right')
        self.display.place(x=350,y=570)
        frame_coords = (0, 0, 400, 400)
        self.display.create_arc(frame_coords, start=0, extent = 359.99, fill='white')
        
        ######################## Arm1 Display init#############################
        xs1 = 190 + (150 - self.arm1_servo_pos) * math.cos(self.alpha)
        ys1 = 190 + (150 - self.arm1_servo_pos) * math.sin(self.alpha)
        
        self.servo1_coord = xs1, ys1, xs1+20 , ys1+20
        self.arm1_sv_dsp = self.display.create_arc(self.servo1_coord, start=math.degrees(self.alpha), extent=358, fill= '#E6B0AA')
        
        xl1 = 190 + (150 - self.arm1_la_pos - self.arm1_servo_pos) * math.cos(self.alpha)
        yl1 = 190 + (150 - self.arm1_la_pos - self.arm1_servo_pos) * math.sin(self.alpha)
        self.servo1_coord = xl1, yl1, xl1+20 , yl1+20
        self.arm1_la_dsp = self.display.create_arc(self.servo1_coord, start=math.degrees(self.alpha), extent=358, fill="#A93226")
        #######################################################################
        
        
        ######################## Arm2 Display init#############################
        xs2 = 190 + (150 - self.arm2_servo_pos) * math.cos(self.alpha + math.pi/3)
        ys2 = 190 + (150 - self.arm2_servo_pos) * math.sin(self.alpha + math.pi/3)
        
        self.servo2_coord = xs2, ys2, xs2+20 , ys2+20
        self.arm2_sv_dsp = self.display.create_arc(self.servo2_coord, start=math.degrees(self.alpha) - 60, extent=358, fill= '#D7BDE2')
        
        xl2 = 190 + (150 - self.arm2_la_pos - self.arm2_servo_pos) * math.cos(self.alpha + math.pi/3)
        yl2 = 190 + (150 - self.arm2_la_pos - self.arm2_servo_pos) * math.sin(self.alpha + math.pi/3)
        self.servo2_coord = xl2, yl2, xl2+20 , yl2+20
        self.arm2_la_dsp = self.display.create_arc(self.servo2_coord, start=math.degrees(self.alpha) - 60, extent=358, fill="#76448A")
        #######################################################################
        
        
        ######################## Arm3 Display init#############################
        xs3 = 190 + (150 - self.arm3_servo_pos) * math.cos(self.alpha + math.pi * 2/3)
        ys3 = 190 + (150 - self.arm3_servo_pos) * math.sin(self.alpha + math.pi * 2/3)
        
        self.servo3_coord = xs3, ys3, xs3+20 , ys3+20
        self.arm3_sv_dsp = self.display.create_arc(self.servo3_coord, start=math.degrees(self.alpha) - 120, extent=358, fill= '#5DADE2')
        
        xl3 = 190 + (150 - self.arm3_la_pos - self.arm3_servo_pos) * math.cos(self.alpha + math.pi * 2/3)
        yl3 = 190 + (150 - self.arm3_la_pos - self.arm3_servo_pos) * math.sin(self.alpha + math.pi * 2/3)
        self.servo3_coord = xl3, yl3, xl3+20 , yl3+20
        self.arm3_la_dsp = self.display.create_arc(self.servo3_coord, start=math.degrees(self.alpha) - 120, extent=358, fill="#21618C")
        #######################################################################
        
        ######################## Arm4 Display init#############################
        xs4 = 190 + (150 - self.arm4_servo_pos) * math.cos(self.alpha + math.pi * 1)
        ys4 = 190 + (150 - self.arm4_servo_pos) * math.sin(self.alpha + math.pi * 1)
        
        self.servo4_coord = xs4, ys4, xs4+20 , ys4+20
        self.arm4_sv_dsp = self.display.create_arc(self.servo4_coord, start=math.degrees(self.alpha) - 180, extent=358, fill= '#58D68D')
        
        xl4 = 190 + (150 - self.arm4_la_pos - self.arm4_servo_pos) * math.cos(self.alpha + math.pi * 1)
        yl4 = 190 + (150 - self.arm4_la_pos - self.arm4_servo_pos) * math.sin(self.alpha + math.pi * 1)
        self.servo4_coord = xl4, yl4, xl4+20 , yl4+20
        self.arm4_la_dsp = self.display.create_arc(self.servo4_coord, start=math.degrees(self.alpha) - 180, extent=358, fill="#1D8348")
        #######################################################################
        
        ######################## Arm5 Display init#############################
        xs5 = 190 + (150 - self.arm5_servo_pos) * math.cos(self.alpha + math.pi * 4/3)
        ys5 = 190 + (150 - self.arm5_servo_pos) * math.sin(self.alpha + math.pi * 4/3)
        
        self.servo5_coord = xs5, ys5, xs5+20 , ys5+20
        self.arm5_sv_dsp = self.display.create_arc(self.servo5_coord, start=math.degrees(self.alpha) - 240, extent=358, fill= '#F8C471')
        
        xl5 = 190 + (150 - self.arm5_la_pos - self.arm5_servo_pos) * math.cos(self.alpha + math.pi * 4/3)
        yl5 = 190 + (150 - self.arm5_la_pos - self.arm5_servo_pos) * math.sin(self.alpha + math.pi * 4/3)
        self.servo5_coord = xl5, yl5, xl5+20 , yl5+20
        self.arm5_la_dsp = self.display.create_arc(self.servo5_coord, start=math.degrees(self.alpha) - 240, extent=358, fill="#A04000")
        #######################################################################
        
        ######################## Arm6 Display init#############################
        xs6 = 190 + (150 - self.arm6_servo_pos) * math.cos(self.alpha + math.pi * 5/3)
        ys6 = 190 + (150 - self.arm6_servo_pos) * math.sin(self.alpha + math.pi * 5/3)
        
        self.servo6_coord = xs6, ys6, xs6+20 , ys6+20
        self.arm6_sv_dsp = self.display.create_arc(self.servo6_coord, start=math.degrees(self.alpha) - 300, extent=358, fill= '#85929E')
        
        xl6 = 190 + (150 - self.arm6_la_pos - self.arm6_servo_pos) * math.cos(self.alpha + math.pi * 5/3)
        yl6 = 190 + (150 - self.arm6_la_pos - self.arm6_servo_pos) * math.sin(self.alpha + math.pi * 5/3)
        self.servo6_coord = xl6, yl6, xl6+20 , yl6+20
        self.arm6_la_dsp = self.display.create_arc(self.servo6_coord, start=math.degrees(self.alpha) - 300, extent=358, fill="#2E4053")
        #######################################################################
        
        
        
        

        # We use the switch_window_button in order to call the show_frame() method as a lambda function
        switch_window_button = tk.Button(
            self,
            text="Go to the Side Page",
            command=lambda: controller.show_frame(SidePage),
        )
        switch_window_button.pack(side="bottom", fill=tk.X)
        
    def display_update(self):
        
        
        ######################## Arm1 display update ##########################
        self.display.delete(self.arm1_sv_dsp)
        self.display.delete(self.arm1_la_dsp)
        xs1 = 190 + (150 - self.arm1_servo_pos) * math.cos(self.alpha)
        ys1 = 190 + (150 - self.arm1_servo_pos) * math.sin(self.alpha)
        
        self.servo1_coord = xs1, ys1, xs1+20, ys1+20
        self.arm1_sv_dsp = self.display.create_arc(self.servo1_coord, start=math.degrees(self.alpha), extent=358, fill='#E6B0AA')
        
        xl1 = 190 + (150 - self.arm1_la_pos - self.arm1_servo_pos) * math.cos(self.alpha)
        yl1 = 190 + (150 - self.arm1_la_pos - self.arm1_servo_pos) * math.sin(self.alpha)
        self.servo1_coord = xl1, yl1, xl1+20 , yl1+20
        self.arm1_la_dsp = self.display.create_arc(self.servo1_coord, start=math.degrees(self.alpha), extent=358, fill="#A93226")
        #######################################################################
        
        ######################## Arm2 display update ##########################
        self.display.delete(self.arm2_sv_dsp)
        self.display.delete(self.arm2_la_dsp)
        xs2 = 190 + (150 - self.arm2_servo_pos) * math.cos(self.alpha + math.pi/3)
        ys2 = 190 + (150 - self.arm2_servo_pos) * math.sin(self.alpha + math.pi/3)
        
        self.servo2_coord = xs2, ys2, xs2+20, ys2+20
        self.arm2_sv_dsp = self.display.create_arc(self.servo2_coord, start=math.degrees(self.alpha) - 60, extent=358, fill='#D7BDE2')
        
        xl2 = 190 + (150 - self.arm2_la_pos - self.arm2_servo_pos) * math.cos(self.alpha + math.pi/3)
        yl2 = 190 + (150 - self.arm2_la_pos - self.arm2_servo_pos) * math.sin(self.alpha + math.pi/3)
        self.servo2_coord = xl2, yl2, xl2+20 , yl2+20
        self.arm2_la_dsp = self.display.create_arc(self.servo2_coord, start=math.degrees(self.alpha) - 60, extent=358, fill="#76448A")
        #######################################################################
        
        ######################## Arm3 display update ##########################
        self.display.delete(self.arm3_sv_dsp)
        self.display.delete(self.arm3_la_dsp)
        xs3 = 190 + (150 - self.arm3_servo_pos) * math.cos(self.alpha + math.pi * 2/3)
        ys3 = 190 + (150 - self.arm3_servo_pos) * math.sin(self.alpha + math.pi * 2/3)
        
        self.servo3_coord = xs3, ys3, xs3+20, ys3+20
        self.arm3_sv_dsp = self.display.create_arc(self.servo3_coord, start=math.degrees(self.alpha) - 120, extent=358, fill='#5DADE2')
        
        xl3 = 190 + (150 - self.arm3_la_pos - self.arm3_servo_pos) * math.cos(self.alpha + math.pi * 2/3)
        yl3 = 190 + (150 - self.arm3_la_pos - self.arm3_servo_pos) * math.sin(self.alpha + math.pi * 2/3)
        self.servo3_coord = xl3, yl3, xl3+20 , yl3+20
        self.arm3_la_dsp = self.display.create_arc(self.servo3_coord, start=math.degrees(self.alpha) - 120, extent=358, fill="#21618C")
        #######################################################################
        
        
        ######################## Arm4 display update ##########################
        self.display.delete(self.arm4_sv_dsp)
        self.display.delete(self.arm4_la_dsp)
        xs4 = 190 + (150 - self.arm4_servo_pos) * math.cos(self.alpha + math.pi * 1)
        ys4 = 190 + (150 - self.arm4_servo_pos) * math.sin(self.alpha + math.pi * 1)
        
        self.servo4_coord = xs4, ys4, xs4+20, ys4+20
        self.arm4_sv_dsp = self.display.create_arc(self.servo4_coord, start=math.degrees(self.alpha) - 180, extent=358, fill='#58D68D')
        
        xl4 = 190 + (150 - self.arm4_la_pos - self.arm4_servo_pos) * math.cos(self.alpha + math.pi * 1)
        yl4 = 190 + (150 - self.arm4_la_pos - self.arm4_servo_pos) * math.sin(self.alpha + math.pi * 1)
        self.servo4_coord = xl4, yl4, xl4+20 , yl4+20
        self.arm4_la_dsp = self.display.create_arc(self.servo4_coord, start=math.degrees(self.alpha) - 180, extent=358, fill="#1D8348")
        #######################################################################
        
        
        ######################## Arm5 display update ##########################
        self.display.delete(self.arm5_sv_dsp)
        self.display.delete(self.arm5_la_dsp)
        xs5 = 190 + (150 - self.arm5_servo_pos) * math.cos(self.alpha + math.pi * 4/3)
        ys5 = 190 + (150 - self.arm5_servo_pos) * math.sin(self.alpha + math.pi * 4/3)
        
        self.servo5_coord = xs5, ys5, xs5+20, ys5+20
        self.arm5_sv_dsp = self.display.create_arc(self.servo5_coord, start=math.degrees(self.alpha) - 240, extent=358, fill='#F8C471')
        
        xl5 = 190 + (150 - self.arm5_la_pos - self.arm5_servo_pos) * math.cos(self.alpha + math.pi * 4/3)
        yl5 = 190 + (150 - self.arm5_la_pos - self.arm5_servo_pos) * math.sin(self.alpha + math.pi * 4/3)
        self.servo5_coord = xl5, yl5, xl5+20 , yl5+20
        self.arm5_la_dsp = self.display.create_arc(self.servo5_coord, start=math.degrees(self.alpha) - 240, extent=358, fill="#A04000")
        #######################################################################
        
        
        ######################## Arm6 display update ##########################
        self.display.delete(self.arm6_sv_dsp)
        self.display.delete(self.arm6_la_dsp)
        xs6 = 190 + (150 - self.arm6_servo_pos) * math.cos(self.alpha + math.pi * 5/3)
        ys6 = 190 + (150 - self.arm6_servo_pos) * math.sin(self.alpha + math.pi * 5/3)
        
        self.servo6_coord = xs6, ys6, xs6+20, ys6+20
        self.arm6_sv_dsp = self.display.create_arc(self.servo6_coord, start=math.degrees(self.alpha) - 300, extent=358, fill='#85929E')
        
        xl6 = 190 + (150 - self.arm6_la_pos - self.arm6_servo_pos) * math.cos(self.alpha + math.pi * 5/3)
        yl6 = 190 + (150 - self.arm6_la_pos - self.arm6_servo_pos) * math.sin(self.alpha + math.pi * 5/3)
        self.servo6_coord = xl6, yl6, xl6+20 , yl6+20
        self.arm6_la_dsp = self.display.create_arc(self.servo6_coord, start=math.degrees(self.alpha) - 300, extent=358, fill="#2E4053")
        #######################################################################
        
    ################### Main Servo Command ####################################  
    def main_scale_ch(self,var):
        value = var
        self.main_val.delete(0,'end')
        self.main_val.insert(0,str(value))
        self.main_com_apply.config(fg='black')
        
    def main_ent_ch(self):
        Value = float(self.main_val.get())
        self.main_com_apply.config(fg='green')
        self.alpha = math.radians(Value) 
        #self.multiarm_com[0] = Value
        #self.multiarm_com_pub.publish(Value)
        self.multi_arm_com.position[0] = Value
        self.multi_arm_com.name = ['main_servo']
        self.multiarm_com_pub.publish(self.multi_arm_com)
        self.display_update()
        
    
    ################### Arm1 functions ########################################    
    def arm1_scale_ch(self,var):
        value = var
        self.arm1_val.delete(0,'end')
        self.arm1_val.insert(0,str(value))
        self.arm1_com_apply.config(fg='black')
        
    def arm1_ent_ch(self):
        Value = float(self.arm1_val.get())
        self.arm1_com_apply.config(fg='green')
        self.arm1_servo_pos = Value * 2
        self.multi_arm_com.position[1] = Value
        self.multi_arm_com.name = ['Arm1_Mserv']
        self.multiarm_com_pub.publish(self.multi_arm_com)
        self.display_update()
                
        
    def arm1_la_scale_ch(self,var):
        value = var
        self.arm1_la_val.delete(0,'end')
        self.arm1_la_val.insert(0,str(value))
        self.arm1_la_com_apply.config(fg='black')
        
    def arm1_la_ent_ch(self):
        Value = float(self.arm1_la_val.get())
        self.arm1_la_com_apply.config(fg='green')
        self.arm1_la_pos = Value * 2
        self.multi_arm_com.position[2] = Value
        self.multi_arm_com.name = ['Arm1_LA']
        self.multiarm_com_pub.publish(self.multi_arm_com)
        self.display_update()
        
    def arm1_rot_scale_ch(self,var):
        value = var
        self.arm1_rot_val.delete(0,'end')
        self.arm1_rot_val.insert(0,str(value))
        self.arm1_rot_com_apply.config(fg='black')
        
    def arm1_rot_ent_ch(self):
        Value = float(self.arm1_rot_val.get())
        self.arm1_rot_com_apply.config(fg='green')
        #self.arm1_la_pos = Value * 2
        self.multi_arm_com.position[3] = Value
        self.multi_arm_com.name = ['Arm1_rot']
        self.multiarm_com_pub.publish(self.multi_arm_com)
        #self.display_update()
    ###########################################################################    
        
    ####################### Arm2 functions ####################################    
    def arm2_scale_ch(self,var):
        value = var
        self.arm2_val.delete(0,'end')
        self.arm2_val.insert(0,str(value))
        self.arm2_com_apply.config(fg='black')
        
    def arm2_ent_ch(self):
        Value = float(self.arm2_val.get())
        self.arm2_com_apply.config(fg='green')
        self.arm2_servo_pos = Value * 2
        self.multi_arm_com.position[4] = Value
        self.multi_arm_com.name = ['Arm2_Mserv']
        self.multiarm_com_pub.publish(self.multi_arm_com)
        self.display_update()
                
        
    def arm2_la_scale_ch(self,var):
        value = var
        self.arm2_la_val.delete(0,'end')
        self.arm2_la_val.insert(0,str(value))
        self.arm2_la_com_apply.config(fg='black')
        
    def arm2_la_ent_ch(self):
        Value = float(self.arm2_la_val.get())
        self.arm2_la_com_apply.config(fg='green')
        self.arm2_la_pos = Value * 2
        self.multi_arm_com.position[5] = Value
        self.multi_arm_com.name = ['Arm2_LA']
        self.multiarm_com_pub.publish(self.multi_arm_com)
        self.display_update()
        
    def arm2_rot_scale_ch(self,var):
        value = var
        self.arm2_rot_val.delete(0,'end')
        self.arm2_rot_val.insert(0,str(value))
        self.arm2_rot_com_apply.config(fg='black')
        
    def arm2_rot_ent_ch(self):
        Value = float(self.arm2_rot_val.get())
        self.arm2_rot_com_apply.config(fg='green')
        #self.arm2_rot_pos = Value * 2
        self.multi_arm_com.position[6] = Value
        self.multi_arm_com.name = ['Arm2_rot']
        self.multiarm_com_pub.publish(self.multi_arm_com)
        #self.display_update()
        
    ###########################################################################
    
    ####################### Arm3 functions ####################################    
    def arm3_scale_ch(self,var):
        value = var
        self.arm3_val.delete(0,'end')
        self.arm3_val.insert(0,str(value))
        self.arm3_com_apply.config(fg='black')
        
    def arm3_ent_ch(self):
        Value = float(self.arm3_val.get())
        self.arm3_com_apply.config(fg='green')
        self.arm3_servo_pos = Value * 2
        self.multi_arm_com.position[7] = Value
        self.multi_arm_com.name = ['Arm3_Mserv']
        self.multiarm_com_pub.publish(self.multi_arm_com)
        self.display_update()
                
        
    def arm3_la_scale_ch(self,var):
        value = var
        self.arm3_la_val.delete(0,'end')
        self.arm3_la_val.insert(0,str(value))
        self.arm3_la_com_apply.config(fg='black')
        
    def arm3_la_ent_ch(self):
        Value = float(self.arm3_la_val.get())
        self.arm3_la_com_apply.config(fg='green')
        self.arm3_la_pos = Value * 2
        self.multi_arm_com.position[8] = Value
        self.multi_arm_com.name = ['Arm3_LA']
        self.multiarm_com_pub.publish(self.multi_arm_com)
        self.display_update()
        
    def arm3_rot_scale_ch(self,var):
        value = var
        self.arm3_rot_val.delete(0,'end')
        self.arm3_rot_val.insert(0,str(value))
        self.arm3_rot_com_apply.config(fg='black')
        
    def arm3_rot_ent_ch(self):
        Value = float(self.arm3_rot_val.get())
        self.arm3_rot_com_apply.config(fg='green')
        #self.arm3_rot_pos = Value * 2
        self.multi_arm_com.position[9] = Value
        self.multi_arm_com.name = ['Arm3_rot']
        self.multiarm_com_pub.publish(self.multi_arm_com)
        #self.display_update()
        
    ###########################################################################
    
    ####################### Arm4 functions ####################################    
    def arm4_scale_ch(self,var):
        value = var
        self.arm4_val.delete(0,'end')
        self.arm4_val.insert(0,str(value))
        self.arm4_com_apply.config(fg='black')
        
    def arm4_ent_ch(self):
        Value = float(self.arm4_val.get())
        self.arm4_com_apply.config(fg='green')
        self.arm4_servo_pos = Value * 2
        self.multi_arm_com.position[10] = Value
        self.multi_arm_com.name = ['Arm4_Mserv']
        self.multiarm_com_pub.publish(self.multi_arm_com)
        self.display_update()
                
        
    def arm4_la_scale_ch(self,var):
        value = var
        self.arm4_la_val.delete(0,'end')
        self.arm4_la_val.insert(0,str(value))
        self.arm4_la_com_apply.config(fg='black')
        
    def arm4_la_ent_ch(self):
        Value = float(self.arm4_la_val.get())
        self.arm4_la_com_apply.config(fg='green')
        self.arm4_la_pos = Value * 2
        self.multi_arm_com.position[11] = Value
        self.multi_arm_com.name = ['Arm4_LA']
        self.multiarm_com_pub.publish(self.multi_arm_com)
        self.display_update()
        
    def arm4_rot_scale_ch(self,var):
        value = var
        self.arm4_rot_val.delete(0,'end')
        self.arm4_rot_val.insert(0,str(value))
        self.arm4_rot_com_apply.config(fg='black')
        
    def arm4_rot_ent_ch(self):
        Value = float(self.arm4_rot_val.get())
        self.arm4_rot_com_apply.config(fg='green')
        #self.arm4_rot_pos = Value * 2
        self.multi_arm_com.position[12] = Value
        self.multi_arm_com.name = ['Arm4_rot']
        self.multiarm_com_pub.publish(self.multi_arm_com)
        #self.display_update()
        
    ###########################################################################
    
    ####################### Arm5 functions ####################################    
    def arm5_scale_ch(self,var):
        value = var
        self.arm5_val.delete(0,'end')
        self.arm5_val.insert(0,str(value))
        self.arm5_com_apply.config(fg='black')
        
    def arm5_ent_ch(self):
        Value = float(self.arm5_val.get())
        self.arm5_com_apply.config(fg='green')
        self.arm5_servo_pos = Value * 2
        self.multi_arm_com.position[13] = Value
        self.multi_arm_com.name = ['Arm5_Mserv']
        self.multiarm_com_pub.publish(self.multi_arm_com)
        self.display_update()
                
        
    def arm5_la_scale_ch(self,var):
        value = var
        self.arm5_la_val.delete(0,'end')
        self.arm5_la_val.insert(0,str(value))
        self.arm5_la_com_apply.config(fg='black')
        
    def arm5_la_ent_ch(self):
        Value = float(self.arm5_la_val.get())
        self.arm5_la_com_apply.config(fg='green')
        self.arm5_la_pos = Value * 2
        self.multi_arm_com.position[14] = Value
        self.multi_arm_com.name = ['Arm5_LA']
        self.multiarm_com_pub.publish(self.multi_arm_com)
        self.display_update()
        
    def arm5_rot_scale_ch(self,var):
        value = var
        self.arm5_rot_val.delete(0,'end')
        self.arm5_rot_val.insert(0,str(value))
        self.arm5_rot_com_apply.config(fg='black')
        
    def arm5_rot_ent_ch(self):
        Value = float(self.arm5_rot_val.get())
        self.arm5_rot_com_apply.config(fg='green')
        #self.arm5_rot_pos = Value * 2
        self.multi_arm_com.position[15] = Value
        self.multi_arm_com.name = ['Arm5_rot']
        self.multiarm_com_pub.publish(self.multi_arm_com)
        #self.display_update()
        
    ###########################################################################
    
    ####################### Arm6 functions ####################################    
    def arm6_scale_ch(self,var):
        value = var
        self.arm6_val.delete(0,'end')
        self.arm6_val.insert(0,str(value))
        self.arm6_com_apply.config(fg='black')
        
    def arm6_ent_ch(self):
        Value = float(self.arm6_val.get())
        self.arm6_com_apply.config(fg='green')
        self.arm6_servo_pos = Value * 2
        self.multi_arm_com.position[16] = Value
        self.multi_arm_com.name = ['Arm6_Mserv']
        self.multiarm_com_pub.publish(self.multi_arm_com)
        self.display_update()
                
        
    def arm6_la_scale_ch(self,var):
        value = var
        self.arm6_la_val.delete(0,'end')
        self.arm6_la_val.insert(0,str(value))
        self.arm6_la_com_apply.config(fg='black')
        
    def arm6_la_ent_ch(self):
        Value = float(self.arm6_la_val.get())
        self.arm6_la_com_apply.config(fg='green')
        self.arm6_la_pos = Value * 2
        self.multi_arm_com.position[17] = Value
        self.multi_arm_com.name = ['Arm6_LA']
        self.multiarm_com_pub.publish(self.multi_arm_com)
        self.display_update()
        
    def arm6_rot_scale_ch(self,var):
        value = var
        self.arm6_rot_val.delete(0,'end')
        self.arm6_rot_val.insert(0,str(value))
        self.arm6_rot_com_apply.config(fg='black')
        
    def arm6_rot_ent_ch(self):
        Value = float(self.arm6_rot_val.get())
        self.arm6_rot_com_apply.config(fg='green')
        #self.arm6_rot_pos = Value * 2
        self.multi_arm_com.position[18] = Value
        self.multi_arm_com.name = ['Arm6_rot']
        self.multiarm_com_pub.publish(self.multi_arm_com)
        #self.display_update()
        
    ###########################################################################
        
        
        
        
        


class SidePage(tk.Frame):
    def __init__(self, parent, controller):
        tk.Frame.__init__(self, parent)
        label = tk.Label(self, text="This is the Side Page")
        label.pack(padx=10, pady=10)

        switch_window_button = tk.Button(
            self,
            text="Go to the Completion Screen",
            command=lambda: controller.show_frame(CompletionScreen),
        )
        switch_window_button.pack(side="bottom", fill=tk.X)


class CompletionScreen(tk.Frame):
    def __init__(self, parent, controller):
        tk.Frame.__init__(self, parent)
        label = tk.Label(self, text="Completion Screen, we did it!")
        label.pack(padx=10, pady=10)
        switch_window_button = ttk.Button(
            self, text="Return to menu", command=lambda: controller.show_frame(MainPage)
        )
        switch_window_button.pack(side="bottom", fill=tk.X)
        
        
if __name__ == "__main__":
    testObj = windows()
    testObj.geometry('1200x1200')
    testObj.mainloop()