/*
Software for the Autonomous Robotic Observation and Behavioral Analysis system. 

WhyCode marker detector

Copyright 2025 Jiri Ulrich, Tomas Krajnik 

Commercial use of the software requires written consent of the copyright holders. 
For Open Research and Educational use, the following applies:

Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements.  See the NOTICE file
distributed with this work for additional information
regarding copyright ownership.  The ASF licenses this file
to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.



*/




#include "whycon/CTimer.h"

namespace whycon
{

CTimer::CTimer(int timeout)
{
  reset();
  timeoutInterval = timeout;
  pause();
}

CTimer::~CTimer()
{}

void CTimer::reset(int timeout)
{
  timeoutInterval = timeout;
  startTime = getRealTime();
  pauseTime = startTime;
}

int64_t CTimer::getRealTime()
{
  struct  timeval currentTime;
  gettimeofday(&currentTime, NULL);
  return currentTime.tv_sec*1000000 + currentTime.tv_usec;
}

int CTimer::getTime()
{
  int result;
  if (running)
  {
    result = getRealTime() - startTime;
  }
  else
  {
    result = pauseTime - startTime;
  }
  return result;
}

bool CTimer::timeOut()
{
  return getTime() > timeoutInterval;
}

bool CTimer::paused()
{
	return (running==false);
}

int CTimer::pause()
{
  running = false;
  return pauseTime = getRealTime();
}

int CTimer::start()
{
  startTime += (getRealTime() - pauseTime);
  running = true;
  return getTime();
}

}
