/*
Software for the Autonomous Robotic Observation and Behavioral Analysis system. 

WhyCode marker detector

Copyright 2025 Jiri Ulrich, Tomas Krajnik 

Commercial use of the software requires written consent of the copyright holders. 
For Open Research and Educational use, the following applies:

Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements.  See the NOTICE file
distributed with this work for additional information
regarding copyright ownership.  The ASF licenses this file
to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.



*/




#ifndef WHYCON__CRAWIMAGE_H
#define WHYCON__CRAWIMAGE_H

#include "whycon/SStructDefs.h"

/**
@author Tom Krajnik
*/

namespace whycon
{

class CRawImage
{

public:

  CRawImage(int width, int height, int bpp);

  ~CRawImage();

  void updateImage(unsigned char* new_data, int width, int height, int bpp);

  void drawTimeStats(int eval_time, int num_markers);

  void drawStats(SMarker &marker, bool trans_2D);

  void drawGuideCalibration(int calib_num, float dim_x, float dim_y);



  void plotLine(int x, int y);

  void plotCenter();

  double getOverallBrightness(bool upperHalf);
  
  int width_;      // image width
  int height_;     // image height
  int size_;       // image size = width * height * bpp
  int bpp_;        // image bits per pixel

  unsigned char* data_;  // image buffer
};

}

#endif
