/*
Software for the Autonomous Robotic Observation and Behavioral Analysis system. 

WhyCode marker detector

Copyright 2025 Jiri Ulrich, Tomas Krajnik 

Commercial use of the software requires written consent of the copyright holders. 
For Open Research and Educational use, the following applies:

Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements.  See the NOTICE file
distributed with this work for additional information
regarding copyright ownership.  The ASF licenses this file
to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.



*/




#ifndef WHYCON__CNECKLACE_H
#define WHYCON__CNECKLACE_H

#include <stdlib.h>
#include <math.h>
#include <stdio.h>
#include "whycon/SStructDefs.h"

namespace whycon
{

typedef struct {
    int id;
    int rotation;
    int hamming;
} SNecklace;


class CNecklace {

    public:
        CNecklace(int bits, int samples, int minimalHamming = 1);

        ~CNecklace();

        SNecklace get(int sequence, bool probabilistic = false, float confidence = 1.0);

        int verifyHamming(int a[], int bits, int len);

        float observationEstimation(float confidence);

        SDecoded decode(char *code, char *realCode, int maxIndex, float segmentV0, float segmentV1);

    private:
        SNecklace unknown;      // default unknown ID
        SNecklace *idArray;     // precalculated IDs

        float* probArray;       // probability for each ID
        int maxID;              // max ID used for Bayes probability
        int idSamples;          // samples to determine black/white signal
        int length;             // number of ID bits
        int idLength;           // amount of all possible IDs
        bool debug;             // debugging the class

        int getEstimatedID();

        int getHamming(int a, int b);

        int getMinimalHamming(int a, int len);
};

}

#endif
