#!/bin/bash

CONFIGPATH=$1

DEVPATH=$(cat $CONFIGPATH | grep "device_path" | tr [:blank:] ' ' | tr -s ' ' | cut -d ' ' -f 3)

CAMBUS=$(udevadm info -a $DEVPATH | grep "busnum" | head -n 1 | grep -o "[0-9]*")
CAMDEV=$(udevadm info -a $DEVPATH | grep "devnum" | head -n 1 | grep -o "[0-9]*")

echo "----- USB RESET $CAMBUS/$CAMDEV $DEVPATH -----" 1>&2

sudo usbreset $CAMBUS/$CAMDEV 1>&2

