# rr_usb_camera

Based on ROS [cv_camera](https://github.com/OTL/cv_camera/tree/6fcbae14de40b8b0b4dbeeeefc746d02d9e172ae) driver.

Respawn add to launch file because OpenCV requires to have full image buffer before setting the `fourcc` decoding property.

## Active Silicon 10x camera

### Setup
1. Apply the udev rules by `sudo ./udev/apply_udev_rules.sh`. Each time the udev rule is updated.

### Config
1. Sample config is below
```
device_path : /dev/video_as_XXXX

image_width : 1920
image_height : 1080
rate : 30

# clockwise rotation
# 0, 90, 180, 270
rotation : 0
```
1. Change the `device_path` based on the symlink in udev rule.

### Adding udev rules
1. List device information with `udevadm info /dev/videoX | grep "ID_SERIAL_SHORT"` where X is the video device sequence number.
```
E: ID_SERIAL_SHORT=1-1708099383-AS10LHD-2
```
1. Add a new line to the file `87-rr-usb-cameras-active-silicon.rules`
```
SUBSYSTEM=="video4linux", ATTR{index}=="0", ATTRS{idVendor}=="0403", ATTRS{idProduct}=="602a", ATTRS{serial}=="X-XXXXXXXXXX-XXXXXXX-X", SYMLINK+="video_as_XXXXXXXXXX", MODE="0666"
```
1. Adjust the `XXXX` based on the attribute `ID_SERIAL_SHORT`. Set the symlink name based on the second part (X-**XXXXXXXXXX**-XXXXXXX-X) of the serial number.
1. Call `apply_udev_rules.sh` on the affected computer to install and activate the udev rules.
