# Hive controller software

## Sensing and interaction

Each hive controller controls two robots, which monitor and interact with the left and right sides of the observation hives.
Each robot consists of an XY actuator, carrying a camera and (optionally) an agent to interact with the bees.
A dedicated control board runs XY actuator firmware *rr_xytable*, which is aimed at minimising vibrations that could disturb the bees (cite:vibrations).
The camera contains an independent optical system capable of software control of the iris, zoom, and focus.
The camera, its optics, XY actuator, and agent actuator have their respective ROS drivers *rr_usb_camera*, *rr_lens_controller*,*rr_xytable*,*rr_poker*, which translate their protocols into ROS-compatible messages.
The queen tag detection node runs a whycode *rr_whycode* method to identify the marker on the queen and/or special markers used to calibrate the system.
The high-level control *rr_xy_calibrator* contains a complex state machine that processes the inputs from the tag detection, and it commands the XY actuator to move to track the queen or scan the honeybee comb.
The high-level control modules running on the left and right sides of the observation hive inform each other of their current state to coordinate their activity.
This is useful when tracking the honeybee queen as she transits from one side of the hive to the other.
Moreover, if the honeybee queen rests for an extended period, the robot that does not track her initiates a high-detail survey of the comb to gather information about the brood.
In specific situations, the high-level control activates the agent behavioural control *rr_interaction*, which then interacts with the queen or the worker bees.

# Terms of Use

The terms of use are specified in the LICENSE file, with attribution information in the NOTICE and CITATION files.
